<?php
   $page_title = "saved";
   include('templates/header.php');
?>
    <section class="section inner-page in-mt">
        <div class="grid-container">
            <div class="grid grid-med">
                <div class="gutter">
                    <nav class="breadcrumbs color-dark-grey">
                        <ul class="trail-items">
                            <li class="trail-item">
                                <a href="index.php" class="trail-itemBlock trail-link trail-home">
                                    <svg class="hom-svg" viewBox="0 0 18 18">
                                        <use xlink:href="#i_home"></use>
                                    </svg> 
                                </a>
                            </li>
                            <li class="trail-item">
                                <span class="trail-arrow">
                                    <svg viewBox="0 0 18 18">
                                        <use xlink:href="#arrow_left"></use>
                                    </svg>
                                </span>
                                <div class="trail-itemBlock">
                                    <span class="trail-label">حسابي</span>
                                </div>
                            </li>
                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </section>
    <section class="section in-mt mod--content">
        <div class="grid-container">
            <div class="grid grid-med">
                <div class="gutter">
                    <div class="profile-container">
                        <div class="profile-sidebar">
                            <div class="profile-header">
                                <div class="user__profile -t">
                                    <div class="user__image user-lg">
                                        <img src="upimages/members/1.png">
                                        <div class="user-bg fill-dimensions bg-black"></div>
                                    </div>
                                    <div class="user__content">
                                        <div class="user__name -mt">د سارة ابراهيم</div>
                                        <div class="user__info">
                                            <div class="user__details color-dark-grey">عضو منذ
                                                نوفمبر 2021</div>
                                        </div>
                                        <div class="l-btn -lb -lh bg-light-blue color-blue">
                                            <div class="l-label">120 متابع</div>
                                            <div class="l-icon -sc">
                                                <svg viewBox="0 0 18 19">
                                                    <use xlink:href="#i_arrowLeft"></use>
                                                </svg>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="pf-menu js-pinned js-pinned-1">
                                <div class="pinned-top-1"></div>
                                <div class="pf-menucontainer pinned-box pinned-box-1">
                                    <div class="profile-links pinned-item -pmx">
                                        <a href="profile.php" class="profile-link">
                                            <div class="ps-item">
                                                <div class="ps-icon">
                                                    <svg viewBox="0 0 22 22">
                                                        <use xlink:href="#i_profile"></use>
                                                    </svg>
                                                </div>
                                                <div class="profile-title">
                                                    <h6>إدارة الحساب</h6>
                                                    <p class="txt-xs color-dark-grey">يمكنك ادارة بيانات حسابك وسجل الانجازات من هنا</p>
                                                </div>
                                            </div>
                                        </a>
                                        <a href="posts.php" class="profile-link">
                                            <div class="ps-item">
                                                <div class="ps-icon">
                                                    <svg viewBox="0 0 20 20">
                                                        <use xlink:href="#i_note"></use>
                                                    </svg>
                                                </div>
                                                <div class="profile-title">
                                                    <h6>إدارة المحتوى</h6>
                                                    <p class="txt-xs color-dark-grey">يمكنك ادارة بيانات حسابك وسجل الانجازات من هنا</p>
                                                </div>
                                            </div>
                                        </a>
                                        <a href="follow.php" class="profile-link">
                                            <div class="ps-item">
                                                <div class="ps-icon">
                                                    <svg viewBox="0 0 20 20">
                                                        <use xlink:href="#i_following"></use>
                                                    </svg>
                                                </div>
                                                <div class="profile-title">
                                                    <h6>إدارة المتابعات</h6>
                                                    <p class="txt-xs color-dark-grey">يمكنك ادارة بيانات حسابك وسجل الانجازات من هنا</p>
                                                </div>
                                            </div>
                                        </a>
                                        <a href="saved.php" class="profile-link current">
                                            <div class="ps-item">
                                                <div class="ps-icon">
                                                    <svg viewBox="0 0 20 20">
                                                        <use xlink:href="#i_saved"></use>

                                                    </svg>
                                                </div>
                                                <div class="psm-icon">
                                                    <svg class="card-linkArrow abs-tr" xmlns="http://www.w3.org/2000/svg" width="45" height="17" viewBox="0 0 45 17">
                                                        <path fill="#e2edff" d="M37.214 12.85a7 7 0 0 0 4.95 2.05H45V17H0v-2.1h2.564a7 7 0 0 0 4.95-2.05l9.9-9.9a7 7 0 0 1 9.9 0l9.899 9.9Z"></path>
                                                    </svg>
                                                </div>
                                                <div class="profile-title">
                                                    <h6>المحفوظات</h6>
                                                    <p class="txt-xs color-dark-grey">يمكنك ادارة بيانات حسابك وسجل الانجازات من هنا</p>
                                                </div>
                                            </div>
                                        </a>
                                        <a href="statistics.php" class="profile-link">
                                            <div class="ps-item">
                                                <div class="ps-icon">
                                                    <svg viewBox="0 0 20 20">
                                                        <use xlink:href="#i_statistics"></use>
                                                    </svg>
                                                </div>
                                                <div class="profile-title">
                                                    <h6>الإحصائيات</h6>
                                                    <p class="txt-xs color-dark-grey">يمكنك ادارة بيانات حسابك وسجل الانجازات من هنا</p>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                    <div class="link-content hidden mobile-visible">
                                        <div class="link-card bg-light-blue color-blue">
                                            <h6 class="link-cardTitle">المحفوظات</h6>
                                            <div class="link-cardText">يمكنك ادارة بيانات حسابك وسجل الانجازات من هنا</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="profile-content ds-hero ">
                        <div class="profile-inner__content">
                            <div class="profile-headline">
                                <h6>المحفوظات</h6>
                            </div>
                            <div class="profile-menu--header relative">
                                <div class="profile-menu">
                                    <div class="profile-list">
                                        <nav class="profile-nav tabs-block">
                                            <ul>
                                                <li>
                                                    <a class="tab-links__item js-tab active" data-menu="1">
                                                        <div class="profile-tab__title">المقالات</div>
                                                        <div class="tl-line abs-br bg-blue"></div>
                                                    </a>
                                                </li>
                                                <li>
                                                    <a class="tab-links__item js-tab" data-menu="2">
                                                        <div class="profile-tab__title">المنشورات</div>
                                                        <div class="tl-line abs-br bg-blue"></div>
                                                    </a>
                                                </li>
                                                <li>
                                                    <a class="tab-links__item js-tab" data-menu="3">
                                                        <div class="profile-tab__title">الألبومات</div>
                                                        <div class="tl-line abs-br bg-blue"></div>
                                                    </a>
                                                </li>
                                            </ul>
                                        </nav>
                                    </div>
                                </div>
                                <div class="t-line abs-br bg-grey"></div>
                            </div>
                            <div class="tabs-content">
                                <div class="tab-item num_1 show">
                                    <div class="ds-holder">
                                        <div class="articles__container">
                                            <div class="articles__list at--sm">
                                                <div class="article__item -ai -ib scale__image">
                                                    <div class="article__image post__image br-sm">
                                                        <a href="">
                                                        <div class="image">
                                                            <img class="br-sm" src="upimages/articles/2.jpg" />
                                                        </div>
                                                    </a>
                                                    </div>
                                                    <div class="article__content">
                                                        <div class="follow-wrp post-gap">
                                                            <div class="post-wrpContent">
                                                                <div class="post__container__details">
                                                                    <a href=""><h6 class="title post__title">إلقاء الضوء على حساسية الأسنان: فهم متكامل للأسباب والتأثيرات بالإضافة إلى أفضل السبل للعلاج والوقاية</h6></a>
                                                                </div>
                                                                <div class="tags mt--xs">
                                                                    <div class="tag__list">
                                                                        <div class="tag__card">
                                                                            <a href="" class="tag__link br-xs bg-grey2">
                                                                                <div class="tag__title">صحة الفم والأسنان</div>
                                                                            </a>
                                                                        </div>
                                                                        <div class="tag__card">
                                                                            <a href="" class="tag__link br-xs bg-grey2">
                                                                                <div class="tag__title">صحة الفم والأسنان</div>
                                                                            </a>
                                                                        </div>
                                                                        <div class="tag__card">
                                                                            <a href="" class="tag__link br-xs bg-grey2">
                                                                                <div class="tag__title">صحة الفم والأسنان</div>
                                                                            </a>
                                                                        </div>
                                                                        <div class="tag__card">
                                                                            <a href="" class="tag__link br-xs bg-grey2">
                                                                                <div class="tag__title">+3</div>
                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="action-btn action-btnStk saved-icon jc-icon default-state">
                                                                <div class="lp-icon">
                                                                    <svg class="-fn" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                        <path class="p-icon" d="M14.0156 1.66699H5.98229C4.20729 1.66699 2.76562 3.11699 2.76562 4.88366V16.6253C2.76562 18.1253 3.84063 18.7587 5.15729 18.0337L9.22396 15.7753C9.65729 15.5337 10.3573 15.5337 10.7823 15.7753L14.849 18.0337C16.1656 18.767 17.2406 18.1337 17.2406 16.6253V4.88366C17.2323 3.11699 15.7906 1.66699 14.0156 1.66699Z" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                                                        <path class="p-check" d="M7.99219 9.16634L9.24219 10.4163L12.5755 7.08301" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                                                    </svg>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="user-flex article__user mt--sm">
                                                        <a href="">
                                                            <div class="user__profile -t -mh">
                                                                <div class="user__image user-sm">
                                                                    <img src="upimages/members/1.png">
                                                                    <div class="user-bg fill-dimensions bg-black"></div>
                                                                </div>
                                                                <div class="user__content">
                                                                    <div class="user__name -mt">د/ سارة ابراهيم</div>
                                                                    <div class="user__info">
                                                                    <div class="user__details color-dark-grey">عضو منذ نوفمبر 2021</div>
                                                                    </div>
                                                                </div>
                                                            </div> 
                                                        </a>
                                                        <div class="post__date">
                                                            <span class="date color-dark-grey">17.مارس 2024</span>
                                                        </div>  
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="article__item -ai -ib scale__image">
                                                    <div class="article__image post__image br-sm">
                                                        <a href="">
                                                        <div class="image">
                                                            <img class="br-sm" src="upimages/articles/2.jpg" />
                                                        </div>
                                                    </a>
                                                    </div>
                                                    <div class="article__content">
                                                        <div class="follow-wrp post-gap">
                                                            <div class="post-wrpContent">
                                                                <div class="post__container__details">
                                                                    <a href=""><h6 class="title post__title">إلقاء الضوء على حساسية الأسنان: فهم متكامل للأسباب والتأثيرات بالإضافة إلى أفضل السبل للعلاج والوقاية</h6></a>
                                                                </div>
                                                                <div class="tags mt--xs">
                                                                    <div class="tag__list">
                                                                        <div class="tag__card">
                                                                            <a href="" class="tag__link br-xs bg-grey2">
                                                                                <div class="tag__title">صحة الفم والأسنان</div>
                                                                            </a>
                                                                        </div>
                                                                        <div class="tag__card">
                                                                            <a href="" class="tag__link br-xs bg-grey2">
                                                                                <div class="tag__title">صحة الفم والأسنان</div>
                                                                            </a>
                                                                        </div>
                                                                        <div class="tag__card">
                                                                            <a href="" class="tag__link br-xs bg-grey2">
                                                                                <div class="tag__title">صحة الفم والأسنان</div>
                                                                            </a>
                                                                        </div>
                                                                        <div class="tag__card">
                                                                            <a href="" class="tag__link br-xs bg-grey2">
                                                                                <div class="tag__title">+3</div>
                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="action-btn action-btnStk saved-icon jc-icon active-state">
                                                                <div class="lp-icon">
                                                                    <svg class="-fn" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                        <path class="p-icon" d="M14.0156 1.66699H5.98229C4.20729 1.66699 2.76562 3.11699 2.76562 4.88366V16.6253C2.76562 18.1253 3.84063 18.7587 5.15729 18.0337L9.22396 15.7753C9.65729 15.5337 10.3573 15.5337 10.7823 15.7753L14.849 18.0337C16.1656 18.767 17.2406 18.1337 17.2406 16.6253V4.88366C17.2323 3.11699 15.7906 1.66699 14.0156 1.66699Z" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                                                        <path class="p-check" d="M7.99219 9.16634L9.24219 10.4163L12.5755 7.08301" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                                                    </svg>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="user-flex article__user mt--sm">
                                                        <a href="">
                                                            <div class="user__profile -t -mh">
                                                                <div class="user__image user-sm">
                                                                    <img src="upimages/members/1.png">
                                                                    <div class="user-bg fill-dimensions bg-black"></div>
                                                                </div>
                                                                <div class="user__content">
                                                                    <div class="user__name -mt">د/ سارة ابراهيم</div>
                                                                    <div class="user__info">
                                                                    <div class="user__details color-dark-grey">عضو منذ نوفمبر 2021</div>
                                                                    </div>
                                                                </div>
                                                            </div> 
                                                        </a>
                                                        <div class="post__date">
                                                            <span class="date color-dark-grey">17.مارس 2024</span>
                                                        </div>  
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="article__item -ai -ib scale__image">
                                                    <div class="article__image post__image br-sm">
                                                        <a href="">
                                                        <div class="image">
                                                            <img class="br-sm" src="upimages/articles/2.jpg" />
                                                        </div>
                                                    </a>
                                                    </div>
                                                    <div class="article__content">
                                                        <div class="follow-wrp post-gap">
                                                            <div class="post-wrpContent">
                                                                <div class="post__container__details">
                                                                    <a href=""><h6 class="title post__title">إلقاء الضوء على حساسية الأسنان: فهم متكامل للأسباب والتأثيرات بالإضافة إلى أفضل السبل للعلاج والوقاية</h6></a>
                                                                </div>
                                                                <div class="tags mt--xs">
                                                                    <div class="tag__list">
                                                                        <div class="tag__card">
                                                                            <a href="" class="tag__link br-xs bg-grey2">
                                                                                <div class="tag__title">صحة الفم والأسنان</div>
                                                                            </a>
                                                                        </div>
                                                                        <div class="tag__card">
                                                                            <a href="" class="tag__link br-xs bg-grey2">
                                                                                <div class="tag__title">صحة الفم والأسنان</div>
                                                                            </a>
                                                                        </div>
                                                                        <div class="tag__card">
                                                                            <a href="" class="tag__link br-xs bg-grey2">
                                                                                <div class="tag__title">صحة الفم والأسنان</div>
                                                                            </a>
                                                                        </div>
                                                                        <div class="tag__card">
                                                                            <a href="" class="tag__link br-xs bg-grey2">
                                                                                <div class="tag__title">+3</div>
                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="action-btn action-btnStk saved-icon jc-icon active-state">
                                                                <div class="lp-icon">
                                                                    <svg class="-fn" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                        <path class="p-icon" d="M14.0156 1.66699H5.98229C4.20729 1.66699 2.76562 3.11699 2.76562 4.88366V16.6253C2.76562 18.1253 3.84063 18.7587 5.15729 18.0337L9.22396 15.7753C9.65729 15.5337 10.3573 15.5337 10.7823 15.7753L14.849 18.0337C16.1656 18.767 17.2406 18.1337 17.2406 16.6253V4.88366C17.2323 3.11699 15.7906 1.66699 14.0156 1.66699Z" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                                                        <path class="p-check" d="M7.99219 9.16634L9.24219 10.4163L12.5755 7.08301" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                                                    </svg>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="user-flex article__user mt--sm">
                                                        <a href="">
                                                            <div class="user__profile -t -mh">
                                                                <div class="user__image user-sm">
                                                                    <img src="upimages/members/1.png">
                                                                    <div class="user-bg fill-dimensions bg-black"></div>
                                                                </div>
                                                                <div class="user__content">
                                                                    <div class="user__name -mt">د/ سارة ابراهيم</div>
                                                                    <div class="user__info">
                                                                    <div class="user__details color-dark-grey">عضو منذ نوفمبر 2021</div>
                                                                    </div>
                                                                </div>
                                                            </div> 
                                                        </a>
                                                        <div class="post__date">
                                                            <span class="date color-dark-grey">17.مارس 2024</span>
                                                        </div>  
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="article__item -ai -ib scale__image">
                                                    <div class="article__image post__image br-sm">
                                                        <a href="">
                                                        <div class="image">
                                                            <img class="br-sm" src="upimages/articles/2.jpg" />
                                                        </div>
                                                    </a>
                                                    </div>
                                                    <div class="article__content">
                                                        <div class="follow-wrp post-gap">
                                                            <div class="post-wrpContent">
                                                                <div class="post__container__details">
                                                                    <a href=""><h6 class="title post__title">إلقاء الضوء على حساسية الأسنان: فهم متكامل للأسباب والتأثيرات بالإضافة إلى أفضل السبل للعلاج والوقاية</h6></a>
                                                                </div>
                                                                <div class="tags mt--xs">
                                                                    <div class="tag__list">
                                                                        <div class="tag__card">
                                                                            <a href="" class="tag__link br-xs bg-grey2">
                                                                                <div class="tag__title">صحة الفم والأسنان</div>
                                                                            </a>
                                                                        </div>
                                                                        <div class="tag__card">
                                                                            <a href="" class="tag__link br-xs bg-grey2">
                                                                                <div class="tag__title">صحة الفم والأسنان</div>
                                                                            </a>
                                                                        </div>
                                                                        <div class="tag__card">
                                                                            <a href="" class="tag__link br-xs bg-grey2">
                                                                                <div class="tag__title">صحة الفم والأسنان</div>
                                                                            </a>
                                                                        </div>
                                                                        <div class="tag__card">
                                                                            <a href="" class="tag__link br-xs bg-grey2">
                                                                                <div class="tag__title">+3</div>
                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="action-btn action-btnStk saved-icon jc-icon active-state">
                                                                <div class="lp-icon">
                                                                    <svg class="-fn" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                        <path class="p-icon" d="M14.0156 1.66699H5.98229C4.20729 1.66699 2.76562 3.11699 2.76562 4.88366V16.6253C2.76562 18.1253 3.84063 18.7587 5.15729 18.0337L9.22396 15.7753C9.65729 15.5337 10.3573 15.5337 10.7823 15.7753L14.849 18.0337C16.1656 18.767 17.2406 18.1337 17.2406 16.6253V4.88366C17.2323 3.11699 15.7906 1.66699 14.0156 1.66699Z" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                                                        <path class="p-check" d="M7.99219 9.16634L9.24219 10.4163L12.5755 7.08301" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                                                    </svg>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="user-flex article__user mt--sm">
                                                        <a href="">
                                                            <div class="user__profile -t -mh">
                                                                <div class="user__image user-sm">
                                                                    <img src="upimages/members/1.png">
                                                                    <div class="user-bg fill-dimensions bg-black"></div>
                                                                </div>
                                                                <div class="user__content">
                                                                    <div class="user__name -mt">د/ سارة ابراهيم</div>
                                                                    <div class="user__info">
                                                                    <div class="user__details color-dark-grey">عضو منذ نوفمبر 2021</div>
                                                                    </div>
                                                                </div>
                                                            </div> 
                                                        </a>
                                                        <div class="post__date">
                                                            <span class="date color-dark-grey">17.مارس 2024</span>
                                                        </div>  
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="article__item -ai -ib scale__image">
                                                    <div class="article__image post__image br-sm">
                                                        <a href="">
                                                        <div class="image">
                                                            <img class="br-sm" src="upimages/articles/2.jpg" />
                                                        </div>
                                                    </a>
                                                    </div>
                                                    <div class="article__content">
                                                        <div class="follow-wrp post-gap">
                                                            <div class="post-wrpContent">
                                                                <div class="post__container__details">
                                                                    <a href=""><h6 class="title post__title">إلقاء الضوء على حساسية الأسنان: فهم متكامل للأسباب والتأثيرات بالإضافة إلى أفضل السبل للعلاج والوقاية</h6></a>
                                                                </div>
                                                                <div class="tags mt--xs">
                                                                    <div class="tag__list">
                                                                        <div class="tag__card">
                                                                            <a href="" class="tag__link br-xs bg-grey2">
                                                                                <div class="tag__title">صحة الفم والأسنان</div>
                                                                            </a>
                                                                        </div>
                                                                        <div class="tag__card">
                                                                            <a href="" class="tag__link br-xs bg-grey2">
                                                                                <div class="tag__title">صحة الفم والأسنان</div>
                                                                            </a>
                                                                        </div>
                                                                        <div class="tag__card">
                                                                            <a href="" class="tag__link br-xs bg-grey2">
                                                                                <div class="tag__title">صحة الفم والأسنان</div>
                                                                            </a>
                                                                        </div>
                                                                        <div class="tag__card">
                                                                            <a href="" class="tag__link br-xs bg-grey2">
                                                                                <div class="tag__title">+3</div>
                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="action-btn action-btnStk saved-icon jc-icon active-state">
                                                                <div class="lp-icon">
                                                                    <svg class="-fn" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                        <path class="p-icon" d="M14.0156 1.66699H5.98229C4.20729 1.66699 2.76562 3.11699 2.76562 4.88366V16.6253C2.76562 18.1253 3.84063 18.7587 5.15729 18.0337L9.22396 15.7753C9.65729 15.5337 10.3573 15.5337 10.7823 15.7753L14.849 18.0337C16.1656 18.767 17.2406 18.1337 17.2406 16.6253V4.88366C17.2323 3.11699 15.7906 1.66699 14.0156 1.66699Z" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                                                        <path class="p-check" d="M7.99219 9.16634L9.24219 10.4163L12.5755 7.08301" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                                                    </svg>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="user-flex article__user mt--sm">
                                                        <a href="">
                                                            <div class="user__profile -t -mh">
                                                                <div class="user__image user-sm">
                                                                    <img src="upimages/members/1.png">
                                                                    <div class="user-bg fill-dimensions bg-black"></div>
                                                                </div>
                                                                <div class="user__content">
                                                                    <div class="user__name -mt">د/ سارة ابراهيم</div>
                                                                    <div class="user__info">
                                                                    <div class="user__details color-dark-grey">عضو منذ نوفمبر 2021</div>
                                                                    </div>
                                                                </div>
                                                            </div> 
                                                        </a>
                                                        <div class="post__date">
                                                            <span class="date color-dark-grey">17.مارس 2024</span>
                                                        </div>  
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-item num_2">
                                    <div class="ds-holder ds-maxCont">
                                        <div class="layout-posts">
                                        <div class="layout-postList">
                                            <div class="layout-postItem">
                                                <div class="lp-content">
                                                    <div class="lp-text post-list">
                                                    سلام عليكم يا أصدقائي،
                                                    <br />
                                                    أشارككم اليوم نتائج دراسة سريرية أجريتها على علاج جديد لمرض السكري من النوع الثاني
                                                    </div>
                                                    <div class="lp-info color-dark-grey">
                                                    <div class="featured__article--info color-dark-grey">
                                                        <span class="f-date">17.مارس.2024</span>
                                                        <span class="dash">-</span>
                                                        <span class="view">1000 مشاهدة</span>
                                                    </div>
                                                    <div class="lp-btns">
                                                        <button class="lp-btn">
                                                            <div class="lp-icon">
                                                                <svg viewBox="0 0 20 20">
                                                                    <use xlink:href="#i_send"></use>
                                                                </svg>
                                                            </div>
                                                        </button>
                                                        <button class="lp-btn">
                                                            <div class="action-btn action-btnStk saved-icon lp-icon default-state">
                                                                <div class="lp-icon">
                                                                    <svg class="-fn" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                        <path class="p-icon" d="M14.0156 1.66699H5.98229C4.20729 1.66699 2.76562 3.11699 2.76562 4.88366V16.6253C2.76562 18.1253 3.84063 18.7587 5.15729 18.0337L9.22396 15.7753C9.65729 15.5337 10.3573 15.5337 10.7823 15.7753L14.849 18.0337C16.1656 18.767 17.2406 18.1337 17.2406 16.6253V4.88366C17.2323 3.11699 15.7906 1.66699 14.0156 1.66699Z" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                                        <path class="p-check" d="M7.99219 9.16634L9.24219 10.4163L12.5755 7.08301" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                                    </svg>
                                                                </div>
                                                            </div>
                                                        </button>
                                                    </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="layout-postItem">
                                                <div class="lp-content">
                                                    <div class="lp-text post-list">
                                                    سلام عليكم يا أصدقائي،
                                                    <br />
                                                    أشارككم اليوم نتائج دراسة سريرية أجريتها على علاج جديد لمرض السكري من النوع الثاني
                                                    <ul>
                                                        <li>شملت الدراسة 100 مريض بالسكري من النوع الثاني.</li>
                                                    </ul>
                                                    </div>
                                                    <div class="accordion-link">
                                                    <div class="accordion js-accordion">
                                                            <div class="accordion__item js-accordion-item js-showAll">
                                                                <div class="accordion-body js-accordion-body">
                                                                <div class="accordion-body__contents">
                                                                    <ul>
                                                                        <li>شملت الدراسة 100 مريض بالسكري من النوع الثاني.</li>
                                                                    </ul> 
                                                                    <p>تم تحديد هذه المتلازمة من خلال العديد من العوامل، ولكن تشير الأبحاث إلى أن هناك فرصة أكبر إذا كانت الأم أكبر من 35 عاماً.</p>
                                                                </div>
                                                                </div>
                                                                <div class="accordion-btn js-accordion-header js-updateScroll">
                                                                <div class="link color-blue cursor">
                                                                        <div class="btn-label">عرض الكل</div>
                                                                </div>
                                                                </div>
                                                            </div>
                                                    </div>
                                                    </div>
                                                    <div class="lp-info color-dark-grey">
                                                    <div class="featured__article--info color-dark-grey">
                                                        <span class="f-date">17.مارس.2024</span>
                                                        <span class="dash">-</span>
                                                        <span class="view">1000 مشاهدة</span>
                                                    </div>
                                                    <div class="lp-btns">
                                                        <button class="lp-btn">
                                                            <div class="lp-icon">
                                                                <svg viewBox="0 0 20 20">
                                                                <use xlink:href="#i_send"></use>
                                                                </svg>
                                                            </div>
                                                        </button>
                                                        <button class="lp-btn">
                                                            <div class="action-btn action-btnStk saved-icon lp-icon sd-icon active-state">
                                                                <div class="lp-icon">
                                                                    <svg class="-fn" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                        <path class="p-icon" d="M14.0156 1.66699H5.98229C4.20729 1.66699 2.76562 3.11699 2.76562 4.88366V16.6253C2.76562 18.1253 3.84063 18.7587 5.15729 18.0337L9.22396 15.7753C9.65729 15.5337 10.3573 15.5337 10.7823 15.7753L14.849 18.0337C16.1656 18.767 17.2406 18.1337 17.2406 16.6253V4.88366C17.2323 3.11699 15.7906 1.66699 14.0156 1.66699Z" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                                        <path class="p-check" d="M7.99219 9.16634L9.24219 10.4163L12.5755 7.08301" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                                    </svg>
                                                                </div>
                                                            </div>
                                                        </button>
                                                    </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="layout-postItem">
                                                <div class="lp-content">
                                                    <div class="lp-text post-list">
                                                    سلام عليكم يا أصدقائي،
                                                    <br />
                                                    أشارككم اليوم نتائج دراسة سريرية أجريتها على علاج جديد لمرض السكري من النوع الثاني
                                                    <ul>
                                                        <li>شملت الدراسة 100 مريض بالسكري من النوع الثاني.</li>
                                                    </ul>
                                                    </div>
                                                    <div class="accordion-link">
                                                    <div class="accordion js-accordion">
                                                            <div class="accordion__item js-accordion-item js-showAll">
                                                                <div class="accordion-body js-accordion-body">
                                                                <div class="accordion-body__contents">
                                                                    <ul>
                                                                        <li>شملت الدراسة 100 مريض بالسكري من النوع الثاني.</li>
                                                                    </ul> 
                                                                    <p>تم تحديد هذه المتلازمة من خلال العديد من العوامل، ولكن تشير الأبحاث إلى أن هناك فرصة أكبر إذا كانت الأم أكبر من 35 عاماً.</p>
                                                                </div>
                                                                </div>
                                                                <div class="accordion-btn js-accordion-header js-updateScroll">
                                                                <div class="link color-blue cursor">
                                                                        <div class="btn-label">عرض الكل</div>
                                                                </div>
                                                                </div>
                                                            </div>
                                                    </div>
                                                    </div>
                                                    <div class="lp-gallery">
                                                    <div class="images-cards lp-imglist single-rowimages single-image">
                                                        <div class="imglist-item">
                                                            <a data-fancybox="gallery-1" href="upimages/articles/1.jpg" class="fancy-imgList">
                                                                <img src="upimages/articles/1.jpg" />
                                                            </a>
                                                        </div>
                                                    </div>
                                                    </div>
                                                    <div class="lp-info color-dark-grey">
                                                    <div class="featured__article--info color-dark-grey">
                                                        <span class="f-date">17.مارس.2024</span>
                                                        <span class="dash">-</span>
                                                        <span class="view">1000 مشاهدة</span>
                                                    </div>
                                                    <div class="lp-btns">
                                                        <button class="lp-btn">
                                                            <div class="lp-icon">
                                                                <svg viewBox="0 0 20 20">
                                                                <use xlink:href="#i_send"></use>
                                                                </svg>
                                                            </div>
                                                        </button>
                                                        <button class="lp-btn">
                                                            <div class="action-btn action-btnStk saved-icon lp-icon sd-icon active-state">
                                                                <div class="lp-icon">
                                                                    <svg class="-fn" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                        <path class="p-icon" d="M14.0156 1.66699H5.98229C4.20729 1.66699 2.76562 3.11699 2.76562 4.88366V16.6253C2.76562 18.1253 3.84063 18.7587 5.15729 18.0337L9.22396 15.7753C9.65729 15.5337 10.3573 15.5337 10.7823 15.7753L14.849 18.0337C16.1656 18.767 17.2406 18.1337 17.2406 16.6253V4.88366C17.2323 3.11699 15.7906 1.66699 14.0156 1.66699Z" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                                        <path class="p-check" d="M7.99219 9.16634L9.24219 10.4163L12.5755 7.08301" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                                    </svg>
                                                                </div>
                                                            </div>
                                                        </button>
                                                    </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="layout-postItem">
                                                <div class="lp-content">
                                                    <div class="lp-text post-list">
                                                    سلام عليكم يا أصدقائي،
                                                    <br />
                                                    أشارككم اليوم نتائج دراسة سريرية أجريتها على علاج جديد لمرض السكري من النوع الثاني
                                                    <ul>
                                                        <li>شملت الدراسة 100 مريض بالسكري من النوع الثاني.</li>
                                                    </ul>
                                                    </div>
                                                    <div class="accordion-link">
                                                    <div class="accordion js-accordion">
                                                            <div class="accordion__item js-accordion-item js-showAll">
                                                                <div class="accordion-body js-accordion-body">
                                                                <div class="accordion-body__contents">
                                                                    <ul>
                                                                        <li>شملت الدراسة 100 مريض بالسكري من النوع الثاني.</li>
                                                                    </ul> 
                                                                    <p>تم تحديد هذه المتلازمة من خلال العديد من العوامل، ولكن تشير الأبحاث إلى أن هناك فرصة أكبر إذا كانت الأم أكبر من 35 عاماً.</p>
                                                                </div>
                                                                </div>
                                                                <div class="accordion-btn js-accordion-header js-updateScroll">
                                                                <div class="link color-blue cursor">
                                                                        <div class="btn-label">عرض الكل</div>
                                                                </div>
                                                                </div>
                                                            </div>
                                                    </div>
                                                    </div>
                                                    <div class="lp-gallery">
                                                    <div class="images-cards lp-imglist single-rowimages">
                                                        <div class="imglist-item">
                                                            <a data-fancybox="gallery-2" href="upimages/articles/1.jpg" class="fancy-imgList">
                                                                <img src="upimages/articles/1.jpg" />
                                                            </a>
                                                        </div>
                                                        <div class="imglist-item">
                                                            <a data-fancybox="gallery-2" href="upimages/status/background/3.jpg"  class="fancy-imgList">
                                                                <img src="upimages/status/background/3.jpg" />
                                                            </a>
                                                        </div>
                                                    </div>
                                                    </div>
                                                    <div class="lp-info color-dark-grey">
                                                    <div class="featured__article--info color-dark-grey">
                                                        <span class="f-date">17.مارس.2024</span>
                                                        <span class="dash">-</span>
                                                        <span class="view">1000 مشاهدة</span>
                                                    </div>
                                                    <div class="lp-btns">
                                                        <button class="lp-btn">
                                                            <div class="lp-icon">
                                                                <svg viewBox="0 0 20 20">
                                                                <use xlink:href="#i_send"></use>
                                                                </svg>
                                                            </div>
                                                        </button>
                                                        <button class="lp-btn">
                                                            <div class="action-btn action-btnStk saved-icon lp-icon sd-icon active-state">
                                                                <div class="lp-icon">
                                                                    <svg class="-fn" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                        <path class="p-icon" d="M14.0156 1.66699H5.98229C4.20729 1.66699 2.76562 3.11699 2.76562 4.88366V16.6253C2.76562 18.1253 3.84063 18.7587 5.15729 18.0337L9.22396 15.7753C9.65729 15.5337 10.3573 15.5337 10.7823 15.7753L14.849 18.0337C16.1656 18.767 17.2406 18.1337 17.2406 16.6253V4.88366C17.2323 3.11699 15.7906 1.66699 14.0156 1.66699Z" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                                        <path class="p-check" d="M7.99219 9.16634L9.24219 10.4163L12.5755 7.08301" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                                    </svg>
                                                                </div>
                                                            </div>
                                                        </button>
                                                    </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="layout-postItem">
                                                <div class="lp-content">
                                                    <div class="lp-text post-list">
                                                    سلام عليكم يا أصدقائي،
                                                    <br />
                                                    أشارككم اليوم نتائج دراسة سريرية أجريتها على علاج جديد لمرض السكري من النوع الثاني
                                                    <ul>
                                                        <li>شملت الدراسة 100 مريض بالسكري من النوع الثاني.</li>
                                                    </ul>
                                                    </div>
                                                    <div class="accordion-link">
                                                    <div class="accordion js-accordion">
                                                            <div class="accordion__item js-accordion-item js-showAll">
                                                                <div class="accordion-body js-accordion-body">
                                                                <div class="accordion-body__contents">
                                                                    <ul>
                                                                        <li>شملت الدراسة 100 مريض بالسكري من النوع الثاني.</li>
                                                                    </ul> 
                                                                    <p>تم تحديد هذه المتلازمة من خلال العديد من العوامل، ولكن تشير الأبحاث إلى أن هناك فرصة أكبر إذا كانت الأم أكبر من 35 عاماً.</p>
                                                                </div>
                                                                </div>
                                                                <div class="accordion-btn js-accordion-header js-updateScroll">
                                                                <div class="link color-blue cursor">
                                                                        <div class="btn-label">عرض الكل</div>
                                                                </div>
                                                                </div>
                                                            </div>
                                                    </div>
                                                    </div>
                                                    <div class="lp-gallery">
                                                    <div class="images-cards lp-imglist two-rowimages items-3">
                                                        <div class="imglist-item">
                                                            <a data-fancybox="gallery-3" href="upimages/articles/1.jpg" class="fancy-imgList">
                                                                <img src="upimages/articles/1.jpg" />
                                                            </a>
                                                        </div>
                                                        <div class="imglist-item">
                                                            <a data-fancybox="gallery-3" href="upimages/status/background/3.jpg" class="fancy-imgList">
                                                                <img src="upimages/status/background/3.jpg" />
                                                            </a>
                                                        </div>
                                                        <div class="imglist-item">
                                                            <a data-fancybox="gallery-3" href="upimages/articles/1.jpg" class="fancy-imgList">
                                                                <img src="upimages/articles/1.jpg" />
                                                            </a>
                                                        </div>
                                                    </div>
                                                    </div>
                                                    <div class="lp-info color-dark-grey">
                                                    <div class="featured__article--info color-dark-grey">
                                                        <span class="f-date">17.مارس.2024</span>
                                                        <span class="dash">-</span>
                                                        <span class="view">1000 مشاهدة</span>
                                                    </div>
                                                    <div class="lp-btns">
                                                        <button class="lp-btn">
                                                            <div class="lp-icon">
                                                                <svg viewBox="0 0 20 20">
                                                                <use xlink:href="#i_send"></use>
                                                                </svg>
                                                            </div>
                                                        </button>
                                                        <button class="lp-btn">
                                                            <div class="action-btn action-btnStk saved-icon lp-icon sd-icon active-state">
                                                                <div class="lp-icon">
                                                                    <svg class="-fn" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                        <path class="p-icon" d="M14.0156 1.66699H5.98229C4.20729 1.66699 2.76562 3.11699 2.76562 4.88366V16.6253C2.76562 18.1253 3.84063 18.7587 5.15729 18.0337L9.22396 15.7753C9.65729 15.5337 10.3573 15.5337 10.7823 15.7753L14.849 18.0337C16.1656 18.767 17.2406 18.1337 17.2406 16.6253V4.88366C17.2323 3.11699 15.7906 1.66699 14.0156 1.66699Z" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                                        <path class="p-check" d="M7.99219 9.16634L9.24219 10.4163L12.5755 7.08301" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                                    </svg>
                                                                </div>
                                                            </div>
                                                        </button>
                                                    </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="layout-postItem">
                                                <div class="lp-content">
                                                    <div class="lp-text post-list">
                                                    سلام عليكم يا أصدقائي،
                                                    <br />
                                                    أشارككم اليوم نتائج دراسة سريرية أجريتها على علاج جديد لمرض السكري من النوع الثاني
                                                    <ul>
                                                        <li>شملت الدراسة 100 مريض بالسكري من النوع الثاني.</li>
                                                    </ul>
                                                    </div>
                                                    <div class="accordion-link">
                                                    <div class="accordion js-accordion">
                                                            <div class="accordion__item js-accordion-item js-showAll">
                                                                <div class="accordion-body js-accordion-body">
                                                                <div class="accordion-body__contents">
                                                                    <ul>
                                                                        <li>شملت الدراسة 100 مريض بالسكري من النوع الثاني.</li>
                                                                    </ul> 
                                                                    <p>تم تحديد هذه المتلازمة من خلال العديد من العوامل، ولكن تشير الأبحاث إلى أن هناك فرصة أكبر إذا كانت الأم أكبر من 35 عاماً.</p>
                                                                </div>
                                                                </div>
                                                                <div class="accordion-btn js-accordion-header js-updateScroll">
                                                                <div class="link color-blue cursor">
                                                                        <div class="btn-label">عرض الكل</div>
                                                                </div>
                                                                </div>
                                                            </div>
                                                    </div>
                                                    </div>
                                                    <div class="lp-gallery">
                                                    <div class="images-cards lp-imglist two-rowimages items-4">
                                                        <div class="imglist-item">
                                                            <a data-fancybox="gallery-4" href="upimages/articles/1.jpg" class="fancy-imgList">
                                                                <img src="upimages/articles/1.jpg" />
                                                            </a> 
                                                        </div>
                                                        <div class="imglist-item">
                                                            <a data-fancybox="gallery-4" href="upimages/status/background/3.jpg" class="fancy-imgList">
                                                                <img src="upimages/status/background/3.jpg" />
                                                            </a>
                                                        </div>
                                                        <div class="imglist-item">
                                                            <a data-fancybox="gallery-4" href="upimages/articles/1.jpg" class="fancy-imgList">
                                                                <img src="upimages/articles/1.jpg" />
                                                            </a>
                                                        </div>
                                                        <div class="imglist-item">
                                                            <a data-fancybox="gallery-4" href="upimages/status/background/3.jpg" class="fancy-imgList">
                                                                <img src="upimages/status/background/3.jpg" />
                                                            </a>
                                                        </div>
                                                    </div>
                                                    </div>
                                                    <div class="lp-info color-dark-grey">
                                                    <div class="featured__article--info color-dark-grey">
                                                        <span class="f-date">17.مارس.2024</span>
                                                        <span class="dash">-</span>
                                                        <span class="view">1000 مشاهدة</span>
                                                    </div>
                                                    <div class="lp-btns">
                                                        <button class="lp-btn">
                                                            <div class="lp-icon">
                                                                <svg viewBox="0 0 20 20">
                                                                <use xlink:href="#i_send"></use>
                                                                </svg>
                                                            </div>
                                                        </button>
                                                        <button class="lp-btn">
                                                            <div class="action-btn action-btnStk saved-icon lp-icon sd-icon active-state">
                                                                <div class="lp-icon">
                                                                    <svg class="-fn" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                        <path class="p-icon" d="M14.0156 1.66699H5.98229C4.20729 1.66699 2.76562 3.11699 2.76562 4.88366V16.6253C2.76562 18.1253 3.84063 18.7587 5.15729 18.0337L9.22396 15.7753C9.65729 15.5337 10.3573 15.5337 10.7823 15.7753L14.849 18.0337C16.1656 18.767 17.2406 18.1337 17.2406 16.6253V4.88366C17.2323 3.11699 15.7906 1.66699 14.0156 1.66699Z" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                                        <path class="p-check" d="M7.99219 9.16634L9.24219 10.4163L12.5755 7.08301" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                                    </svg>
                                                                </div>
                                                            </div>
                                                        </button>
                                                    </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="layout-postItem">
                                                <div class="lp-content">
                                                    <div class="lp-text post-list">
                                                    سلام عليكم يا أصدقائي،
                                                    <br />
                                                    أشارككم اليوم نتائج دراسة سريرية أجريتها على علاج جديد لمرض السكري من النوع الثاني
                                                    <ul>
                                                        <li>شملت الدراسة 100 مريض بالسكري من النوع الثاني.</li>
                                                    </ul>
                                                    </div>
                                                    <div class="accordion-link">
                                                    <div class="accordion js-accordion">
                                                            <div class="accordion__item js-accordion-item js-showAll">
                                                                <div class="accordion-body js-accordion-body">
                                                                <div class="accordion-body__contents">
                                                                    <ul>
                                                                        <li>شملت الدراسة 100 مريض بالسكري من النوع الثاني.</li>
                                                                    </ul> 
                                                                    <p>تم تحديد هذه المتلازمة من خلال العديد من العوامل، ولكن تشير الأبحاث إلى أن هناك فرصة أكبر إذا كانت الأم أكبر من 35 عاماً.</p>
                                                                </div>
                                                                </div>
                                                                <div class="accordion-btn js-accordion-header js-updateScroll">
                                                                <div class="link color-blue cursor">
                                                                        <div class="btn-label">عرض الكل</div>
                                                                </div>
                                                                </div>
                                                            </div>
                                                    </div>
                                                    </div>
                                                    <div class="lp-gallery">
                                                    <div class="images-cards lp-imglist two-rowimages items-4">
                                                        <div class="imglist-item">
                                                            <a data-fancybox="gallery-5" href="upimages/articles/1.jpg" class="fancy-imgList">
                                                                <img src="upimages/articles/1.jpg" />
                                                            </a>
                                                        </div>
                                                        <div class="imglist-item">
                                                            <a data-fancybox="gallery-5" href="upimages/status/background/2.jpg" class="fancy-imgList">
                                                                <img src="upimages/status/background/2.jpg" />
                                                            </a>
                                                        </div>
                                                        <div class="imglist-item">
                                                            <a data-fancybox="gallery-5" href="upimages/articles/3.jpg" class="fancy-imgList">
                                                                <img src="upimages/articles/3.jpg" />
                                                            </a>
                                                        </div>
                                                        <div class="imglist-item">
                                                            <a data-fancybox="gallery-5" href="upimages/status/background/4.jpg" class="fancy-imgList">
                                                                <img src="upimages/status/background/4.jpg" />
                                                                <div class="fancy__imageBg fill-dimensions">
                                                                <div class="fn__bg fill-dimensions bg-black opc-3"></div>
                                                                <div class="images__count color-white">+6</div>
                                                                </div>
                                                            </a>
                                                        </div>
                                                        <div class="hidden-gallery">
                                                            <div class="imglist-item">
                                                                <a data-fancybox="gallery-5" href="upimages/status/background/5.jpg" class="fancy-imgList">
                                                                <img src="upimages/status/background/5.jpg" />
                                                                </a>
                                                            </div>
                                                            <div class="imglist-item">
                                                                <a data-fancybox="gallery-5" href="upimages/status/background/6.jpg" class="fancy-imgList">
                                                                <img src="upimages/status/background/6.jpg" />
                                                                </a> 
                                                            </div>
                                                        </div>
                                                    </div>
                                                    </div>
                                                    <div class="lp-info color-dark-grey">
                                                    <div class="featured__article--info color-dark-grey">
                                                        <span class="f-date">17.مارس.2024</span>
                                                        <span class="dash">-</span>
                                                        <span class="view">1000 مشاهدة</span>
                                                    </div>
                                                    <div class="lp-btns">
                                                        <button class="lp-btn">
                                                            <div class="lp-icon">
                                                                <svg viewBox="0 0 20 20">
                                                                <use xlink:href="#i_send"></use>
                                                                </svg>
                                                            </div>
                                                        </button>
                                                        <button class="lp-btn">
                                                            <div class="action-btn action-btnStk saved-icon lp-icon sd-icon active-state">
                                                                <div class="lp-icon">
                                                                    <svg class="-fn" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                        <path class="p-icon" d="M14.0156 1.66699H5.98229C4.20729 1.66699 2.76562 3.11699 2.76562 4.88366V16.6253C2.76562 18.1253 3.84063 18.7587 5.15729 18.0337L9.22396 15.7753C9.65729 15.5337 10.3573 15.5337 10.7823 15.7753L14.849 18.0337C16.1656 18.767 17.2406 18.1337 17.2406 16.6253V4.88366C17.2323 3.11699 15.7906 1.66699 14.0156 1.66699Z" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                                        <path class="p-check" d="M7.99219 9.16634L9.24219 10.4163L12.5755 7.08301" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                                    </svg>
                                                                </div>
                                                            </div>
                                                        </button>
                                                    </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        </div>
                                    </div>   
                                </div>
                                <div class="tab-item num_3">
                                    <div class="ds-holder ds-maxCont">
                                        <div class="layout-posts">
                                            <div class="layout-postList">
                                                <div class="layout-postItem">
                                                    <div class="lp-content">
                                                        <div class="lp-title">
                                                        <h6>من معرض UDS</h6>
                                                        </div>
                                                        <div class="lp-gallery">
                                                        <div class="images-cards gallery-grid js-gallery">
                                                            <div class="imglist-item image1 js-imageHover">
                                                                <a data-fancybox="gallery-6" href="upimages/articles/1.jpg" class="fancy-imgList">
                                                                    <img src="upimages/articles/1.jpg" />
                                                                </a>
                                                            </div>
                                                            <div class="imglist-item image2">
                                                                <a data-fancybox="gallery-6" href="upimages/status/background/3.jpg" class="fancy-imgList">
                                                                    <img src="upimages/status/background/3.jpg" />
                                                                </a> 
                                                            </div>
                                                            <div class="imglist-item image3">
                                                                <a data-fancybox="gallery-6" href="upimages/articles/1.jpg" class="fancy-imgList">
                                                                    <img src="upimages/articles/1.jpg" />
                                                                </a>
                                                            </div>
                                                            <div class="imglist-item image4">
                                                                <a data-fancybox="gallery-6" href="upimages/status/background/3.jpg" class="fancy-imgList">
                                                                    <img src="upimages/status/background/3.jpg" />
                                                                </a>
                                                            </div>
                                                        </div>
                                                        </div>
                                                        <div class="lp-info color-dark-grey">
                                                        <div class="featured__article--info color-dark-grey">
                                                            <span class="f-date">17.مارس.2024</span>
                                                            <span class="dash">-</span>
                                                            <span class="view">1000 مشاهدة</span>
                                                        </div>
                                                        <div class="lp-btns">
                                                            <button class="lp-btn">
                                                                <div class="lp-icon">
                                                                    <svg viewBox="0 0 20 20">
                                                                    <use xlink:href="#i_send"></use>
                                                                    </svg>
                                                                </div>
                                                            </button>
                                                        <button class="lp-btn">
                                                            <div class="action-btn action-btnStk saved-icon lp-icon default-state">
                                                                <div class="lp-icon">
                                                                    <svg class="-fn" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                        <path class="p-icon" d="M14.0156 1.66699H5.98229C4.20729 1.66699 2.76562 3.11699 2.76562 4.88366V16.6253C2.76562 18.1253 3.84063 18.7587 5.15729 18.0337L9.22396 15.7753C9.65729 15.5337 10.3573 15.5337 10.7823 15.7753L14.849 18.0337C16.1656 18.767 17.2406 18.1337 17.2406 16.6253V4.88366C17.2323 3.11699 15.7906 1.66699 14.0156 1.66699Z" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                                        <path class="p-check" d="M7.99219 9.16634L9.24219 10.4163L12.5755 7.08301" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                                    </svg>
                                                                </div>
                                                            </div>
                                                        </button>
                                                        </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="layout-postItem">
                                                    <div class="lp-content">
                                                        <div class="lp-title">
                                                        <h6>من معرض UDS</h6>
                                                        </div>
                                                        <div class="lp-gallery">
                                                        <div class="images-cards gallery-grid js-gallery">
                                                            <div class="imglist-item image1 js-imageHover">
                                                                <a data-fancybox="gallery-7" data-options='{"src": "#imglist-content-71", "touch": false, "smallBtn" : false}' href="javascript:;" itemprop="contentUrl" data-size="1200x600" class="fancy-imgList">
                                                                    <img src="upimages/articles/1.jpg" />
                                                                </a>
                                                                <div style="display: none;" id="imglist-content-71" class="imglist-lightbox">
                                                                    <img src="upimages/articles/1.jpg" />
                                                                </div> 
                                                            </div>
                                                            <div class="imglist-item image2">
                                                                <a data-fancybox="gallery-7" data-options='{"src": "#imglist-content-72", "touch": false, "smallBtn" : false}' href="javascript:;" itemprop="contentUrl" data-size="1200x600" class="fancy-imgList">
                                                                    <img src="upimages/status/background/3.jpg" />
                                                                </a>
                                                                <div style="display: none;" id="imglist-content-72" class="imglist-lightbox">
                                                                    <img src="upimages/status/background/3.jpg" />
                                                                </div> 
                                                            </div>
                                                            <div class="imglist-item image3">
                                                                <a data-fancybox="gallery-7" data-options='{"src": "#imglist-content-73", "touch": false, "smallBtn" : false}' href="javascript:;" itemprop="contentUrl" data-size="1200x600" class="fancy-imgList">
                                                                    <img src="upimages/articles/1.jpg" />
                                                                </a>
                                                                <div style="display: none;" id="imglist-content-73" class="imglist-lightbox">
                                                                    <img src="upimages/articles/1.jpg" />
                                                                </div> 
                                                            </div>
                                                            <div class="imglist-item image4">
                                                                <a data-fancybox="gallery-7" data-options='{"src": "#imglist-content-74", "touch": false, "smallBtn" : false}' href="javascript:;" itemprop="contentUrl" data-size="1200x600" class="fancy-imgList">
                                                                    <img src="upimages/status/background/3.jpg" />
                                                                </a>
                                                                <div style="display: none;" id="imglist-content-74" class="imglist-lightbox">
                                                                    <img src="upimages/status/background/3.jpg" />
                                                                </div> 
                                                            </div>
                                                        </div>
                                                        </div>
                                                        <div class="lp-info color-dark-grey">
                                                        <div class="featured__article--info color-dark-grey">
                                                            <span class="f-date">17.مارس.2024</span>
                                                            <span class="dash">-</span>
                                                            <span class="view">1000 مشاهدة</span>
                                                        </div>
                                                        <div class="lp-btns">
                                                            <button class="lp-btn">
                                                                <div class="lp-icon">
                                                                    <svg viewBox="0 0 20 20">
                                                                        <use xlink:href="#i_send"></use>
                                                                    </svg>
                                                                </div>
                                                            </button>
                                                        <button class="lp-btn">
                                                            <div class="action-btn action-btnStk saved-icon lp-icon sd-icon active-state">
                                                                <div class="lp-icon">
                                                                    <svg class="-fn" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                        <path class="p-icon" d="M14.0156 1.66699H5.98229C4.20729 1.66699 2.76562 3.11699 2.76562 4.88366V16.6253C2.76562 18.1253 3.84063 18.7587 5.15729 18.0337L9.22396 15.7753C9.65729 15.5337 10.3573 15.5337 10.7823 15.7753L14.849 18.0337C16.1656 18.767 17.2406 18.1337 17.2406 16.6253V4.88366C17.2323 3.11699 15.7906 1.66699 14.0156 1.66699Z" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                                        <path class="p-check" d="M7.99219 9.16634L9.24219 10.4163L12.5755 7.08301" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                                                    </svg>
                                                                </div>
                                                            </div>
                                                        </button>
                                                        </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php
   include('templates/footer.php');
?>