<?php
   $page_title = "profile";
   include('templates/header.php');
?>
    <section class="section inner-page in-mt">
        <div class="grid-container">
            <div class="grid grid-med">
                <div class="gutter">
                    <nav class="breadcrumbs color-dark-grey">
                        <ul class="trail-items">
                            <li class="trail-item">
                                <a href="index.php" class="trail-itemBlock trail-link trail-home">
                                    <svg class="hom-svg" viewBox="0 0 18 18">
                                        <use xlink:href="#i_home"></use>
                                    </svg> 
                                </a>
                            </li>
                            <li class="trail-item">
                                <span class="trail-arrow">
                                    <svg viewBox="0 0 18 18">
                                        <use xlink:href="#arrow_left"></use>
                                    </svg>
                                </span>
                                <div class="trail-itemBlock">
                                    <span class="trail-label">حسابي</span>
                                </div>
                            </li>
                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </section>
    <section class="section in-mt mod--content">
        <div class="grid-container">
            <div class="grid grid-med">
                <div class="gutter">
                    <div class="profile-container">
                        <div class="profile-sidebar">
                            <div class="profile-header">
                                <div class="user__profile -t">
                                    <div class="user__image user-lg">
                                        <img src="upimages/members/1.png">
                                        <div class="user-bg fill-dimensions bg-black"></div>
                                    </div>
                                    <div class="user__content">
                                        <div class="user__name -mt">د سارة ابراهيم</div>
                                        <div class="user__info">
                                            <div class="user__details color-dark-grey">عضو منذ
                                                نوفمبر 2021</div>
                                        </div>
                                        <div class="l-btn -lb -lh bg-light-blue color-blue">
                                            <div class="l-label">120 متابع</div>
                                            <div class="l-icon -sc">
                                                <svg viewBox="0 0 18 19">
                                                    <use xlink:href="#i_arrowLeft"></use>
                                                </svg>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="pf-menu js-pinned js-pinned-1">
                                <div class="pinned-top-1"></div>
                                <div class="pf-menucontainer pinned-box pinned-box-1">
                                    <div class="profile-links pinned-item -pmx">
                                        <a href="profile.php" class="profile-link current">
                                            <div class="ps-item">
                                                <div class="ps-icon">
                                                    <svg viewBox="0 0 22 22">
                                                        <use xlink:href="#i_profile"></use>
                                                    </svg>
                                                </div>
                                                <div class="psm-icon">
                                                    <svg class="card-linkArrow abs-tr" xmlns="http://www.w3.org/2000/svg" width="45" height="17" viewBox="0 0 45 17">
                                                        <path fill="#e2edff" d="M37.214 12.85a7 7 0 0 0 4.95 2.05H45V17H0v-2.1h2.564a7 7 0 0 0 4.95-2.05l9.9-9.9a7 7 0 0 1 9.9 0l9.899 9.9Z"></path>
                                                    </svg>
                                                </div>
                                                <div class="profile-title">
                                                    <h6>إدارة الحساب</h6>
                                                    <p class="txt-xs color-dark-grey">يمكنك ادارة بيانات حسابك وسجل الانجازات من هنا</p>
                                                </div>
                                            </div>
                                        </a>
                                        <a href="posts.php" class="profile-link">
                                            <div class="ps-item">
                                                <div class="ps-icon">
                                                    <svg viewBox="0 0 20 20">
                                                        <use xlink:href="#i_note"></use>
                                                    </svg>
                                                </div>
                                                <div class="profile-title">
                                                    <h6>إدارة المحتوى</h6>
                                                    <p class="txt-xs color-dark-grey">يمكنك ادارة بيانات حسابك وسجل الانجازات من هنا</p>
                                                </div>
                                            </div>
                                        </a>
                                        <a href="follow.php" class="profile-link">
                                            <div class="ps-item">
                                                <div class="ps-icon">
                                                    <svg viewBox="0 0 20 20">
                                                        <use xlink:href="#i_following"></use>
                                                    </svg>
                                                </div>
                                                <div class="profile-title">
                                                    <h6>إدارة المتابعات</h6>
                                                    <p class="txt-xs color-dark-grey">يمكنك ادارة بيانات حسابك وسجل الانجازات من هنا</p>
                                                </div>
                                            </div>
                                        </a>
                                        <a href="saved.php" class="profile-link">
                                            <div class="ps-item">
                                                <div class="ps-icon">
                                                    <svg viewBox="0 0 20 20">
                                                        <use xlink:href="#i_saved"></use>

                                                    </svg>
                                                </div>
                                                <div class="profile-title">
                                                    <h6>المحفوظات</h6>
                                                    <p class="txt-xs color-dark-grey">يمكنك ادارة بيانات حسابك وسجل الانجازات من هنا</p>
                                                </div>
                                            </div>
                                        </a>
                                        <a href="statistics.php" class="profile-link">
                                            <div class="ps-item">
                                                <div class="ps-icon">
                                                    <svg viewBox="0 0 20 20">
                                                        <use xlink:href="#i_statistics"></use>
                                                    </svg>
                                                </div>
                                                <div class="profile-title">
                                                    <h6>الإحصائيات</h6>
                                                    <p class="txt-xs color-dark-grey">يمكنك ادارة بيانات حسابك وسجل الانجازات من هنا</p>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                    <div class="link-content hidden mobile-visible">
                                        <div class="link-card bg-light-blue color-blue">
                                            <h6 class="link-cardTitle">إدارة الحساب</h6>
                                            <div class="link-cardText">يمكنك ادارة بيانات حسابك وسجل الانجازات من هنا</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="profile-content ds-hero ">
                            <div class="profile-inner__content">
                                <div class="profile-headline">
                                    <h6>إدارة الحساب</h6>
                                </div>
                                <div class="profile-menu--header relative mt--sm">
                                    <div class="profile-menu">
                                        <div class="profile-list relative">
                                            <div class="t-line abs-br bg-grey hidden mobile-visible"></div>
                                            <nav class="profile-nav tabs-block">
                                                <ul>
                                                    <li>
                                                        <a class="tab-links__item js-tab active" data-menu="1">
                                                            <div class="profile-tab__title">البيانات العامة</div>
                                                            <div class="tl-line abs-br bg-blue"></div>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="tab-links__item js-tab" data-menu="2">
                                                            <div class="profile-tab__title">العناوين</div>
                                                            <div class="tl-line abs-br bg-blue"></div>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="tab-links__item js-tab" data-menu="3">
                                                            <div class="profile-tab__title">سجل الإنجازات</div>
                                                            <div class="tl-line abs-br bg-blue"></div>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </nav>
                                        </div>
                                        <div class="dst-btns">
                                            <div class="dst-btn tab-item num_1 show">
                                                <a href="" class="l-btn -bt bg-light-blue color-blue">
                                                <div class="l-label">صفحة ملفك الشخصي</div>
                                                    <div class="l-icon -sc">
                                                        <svg viewBox="0 0 18 19">
                                                            <use xlink:href="#i_arrowLeft"></use>
                                                        </svg>
                                                    </div>
                                                </a>
                                            </div>
                                            <div class="dst-btn tab-item num_2">
                                                <a data-fancybox data-src="#add-location" class="l-btn -bt bg-blue color-white fancy-dialog">
                                                    <div class="l-label">إضافة موقع</div>
                                                </a>
                                                <div style="display: none;" id="add-location" class="content__lightbox lb-med">
                                                    <div class="popup__wrp">
                                                        <div class="popup__holder ds-holder">
                                                            <form class="form mod--form" action="" method="">
                                                                <div class="fds-formCont">
                                                                    <div class="fds-title -tl">
                                                                        <h6>إضافة عنوان جديد</h6>
                                                                        <p class="color-dark-grey">َيمكنك اضافة عنوان جديد بكل التفاصيل التي تهمك</p>
                                                                        <div class="t-line abs-br bg-grey"></div>
                                                                    </div>
                                                                    <div class="fds-container">  
                                                                        <div class="fds-rows">  
                                                                            <div class="fds-row">  
                                                                                <div class="fds-location">
                                                                                    <div class="lm-title">
                                                                                        <span class="lm-icon -sc">
                                                                                            <svg viewBox="0 0 18 18">
                                                                                                <use xlink:href="#i__marker"></use>
                                                                                            </svg>
                                                                                        </span>
                                                                                        <h6 class="title">الموقع</h6>
                                                                                    </div>
                                                                                    <div class="fds-shiftRow">
                                                                                        <div class="location-map relative">
                                                                                            <div class="location-search abs-tr">
                                                                                                <div class="nav-search search-wrap">
                                                                                                    <div class="form-group">
                                                                                                        <input type="text" class="input w-input field bg-white" placeholder="" required="">
                                                                                                    </div>
                                                                                                    <button type="submit" class="btn form__submit-button abs-tr">
                                                                                                        <div class="form__submit-wrap">
                                                                                                        <div class="icon mod--search-submit w-embed">
                                                                                                                <svg viewBox="0 0 22 22">
                                                                                                                    <use xlink:href="#i_search"></use>
                                                                                                                </svg>
                                                                                                        </div>
                                                                                                        </div>
                                                                                                    </button>
                                                                                                </div>
                                                                                            </div>
                                                                                            <div class="location-iframe bg-grey br-sm overflow">
                                                                                                <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3847.7170292397514!2d44.195971373857496!3d15.337605658610833!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x1603dbfa501dd7d7%3A0x60b12f2d7d144063!2z2YXYsdmD2LIg2KfZhNmD2YXZitmFINin2YTYqtis2KfYsdmK!5e0!3m2!1sen!2s!4v1721414831414!5m2!1sen!2s" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                                                                                            </div>
                                                                                        </div>
                                                                                        <div class="field-group mt--xs3">
                                                                                            <div class="field-item">
                                                                                                <div class="txtarea-wrp text">
                                                                                                    <!-- <textarea type="text" class="w-field color-dark-grey auto-resize-textarea">وصف العنوان</textarea> -->
                                                                                                    <div class="auto-textBox bg-light-blue3 color-dark-grey" contenteditable="true">وصف العنوان</div>
                                                                                                </div>
                                                                                            </div>
                                                                                            <div class="field-item">
                                                                                                <div class="txtarea-wrp text">
                                                                                                    <div class="auto-textBox bg-light-blue3 color-dark-grey" contenteditable="true">ملاحظة على العنوان</div>
                                                                                                </div>
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>  
                                                                            </div>  
                                                                            <div class="fds-row">  
                                                                                <div class="fds-location">
                                                                                    <div class="lm-title">
                                                                                        <span class="lm-icon -sc">
                                                                                            <svg viewBox="0 0 25 25">
                                                                                                <use xlink:href="#i_calender"></use>
                                                                                            </svg>
                                                                                        </span>
                                                                                        <h6 class="title">مواعيد الدوام</h6>
                                                                                    </div>
                                                                                    <div class="fds-shiftRow">
                                                                                        <div class="schedule">
                                                                                            <div class="days-container">
                                                                                                <div class="day">
                                                                                                    <div class="switch">
                                                                                                        <input type="checkbox" id="saturday1" class="day-switch">
                                                                                                        <label for="saturday1" class="day-btn"></label>
                                                                                                        <span class="day-name">السبت</span>
                                                                                                        <span class="status">مغلق</span>
                                                                                                    </div>
                                                                                                    <div class="periods"></div>
                                                                                                </div>  
                                                                                                <div class="day">
                                                                                                    <div class="switch">
                                                                                                        <input type="checkbox" id="sunday1" class="day-switch">
                                                                                                        <label for="sunday1" class="day-btn"></label>
                                                                                                        <span class="day-name">الأحد</span>
                                                                                                        <span class="status">مغلق</span>
                                                                                                    </div>
                                                                                                    <div class="periods"></div>
                                                                                                </div> 
                                                                                                <div class="day">
                                                                                                    <div class="switch">
                                                                                                        <input type="checkbox" id="monday1" class="day-switch">
                                                                                                        <label for="monday1" class="day-btn"></label>
                                                                                                        <span class="day-name">الأثنين</span>
                                                                                                        <span class="status">مغلق</span>
                                                                                                    </div>
                                                                                                    <div class="periods"></div>
                                                                                                </div> 
                                                                                                <div class="day">
                                                                                                    <div class="switch">
                                                                                                        <input type="checkbox" id="tuesday1" class="day-switch">
                                                                                                        <label for="tuesday1" class="day-btn"></label>
                                                                                                        <span class="day-name">الثلثاء</span>
                                                                                                        <span class="status">مغلق</span>
                                                                                                    </div>
                                                                                                    <div class="periods"></div>
                                                                                                </div> 
                                                                                                <div class="day">
                                                                                                    <div class="switch">
                                                                                                        <input type="checkbox" id="wensday1" class="day-switch">
                                                                                                        <label for="wensday1" class="day-btn"></label>
                                                                                                        <span class="day-name">الأربعاء</span>
                                                                                                        <span class="status">مغلق</span>
                                                                                                    </div>
                                                                                                    <div class="periods"></div>
                                                                                                </div> 
                                                                                                <div class="day">
                                                                                                    <div class="switch">
                                                                                                        <input type="checkbox" id="thursday1" class="day-switch">
                                                                                                        <label for="thursday1" class="day-btn"></label>
                                                                                                        <span class="day-name">الخميس</span>
                                                                                                        <span class="status">مغلق</span>
                                                                                                    </div>
                                                                                                    <div class="periods"></div>
                                                                                                </div> 
                                                                                                <div class="day">
                                                                                                    <div class="switch">
                                                                                                        <input type="checkbox" id="friday1" class="day-switch">
                                                                                                        <label for="friday1" class="day-btn"></label>
                                                                                                        <span class="day-name">الجمعة</span>
                                                                                                        <span class="status">مغلق</span>
                                                                                                    </div>
                                                                                                    <div class="periods"></div>
                                                                                                </div>                                                                                   
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>  
                                                                            </div> 
                                                                            <div class="fds-row">  
                                                                                <div class="fds-location">
                                                                                    <div class="lm-title">
                                                                                        <span class="lm-icon -sc">
                                                                                            <svg viewBox="0 0 19 18">
                                                                                                <use xlink:href="#i_call"></use>
                                                                                            </svg>
                                                                                        </span>
                                                                                        <h6 class="title">أرقام التواصل</h6>
                                                                                    </div>
                                                                                    <div class="fds-shiftRow">
                                                                                        <div class="field-group">
                                                                                        <div class="field-item">
                                                                                                <input type="text" class="input w-input field bg-light-blue3" placeholder="رقم الهاتف" required="">
                                                                                        </div>    
                                                                                        <div class="field-item">
                                                                                                <input type="text" class="input w-input field bg-light-blue3" placeholder="رقم الهاتف البديل (اختياري)" required="">
                                                                                        </div>                                                                                     
                                                                                        </div>
                                                                                    </div>
                                                                                </div>  
                                                                            </div>
                                                                            <div class="btns-group je mt--sm">
                                                                                <button class="btn bg-blue color-white">إضافة</button>
                                                                                <button class="btn bg-light-blue2 color-blue">إلغاء</button>
                                                                            </div>
                                                                        </div>  
                                                                    </div>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="dst-btn tab-item num_3">
                                                <a class="l-btn -bt bg-blue color-white open-popup-btn" data-popup="add-archive">
                                                    <div class="l-label">إضافة إنجاز</div>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="t-line abs-br bg-grey mobile-hidden"></div>
                                </div>
                                <div class="tabs-content">
                                    <div class="tab-item num_1 show">
                                        <div class="ds-holder">
                                            <div class="pp-hero-header featured-block">
                                                <div class="pp-hero-image hi-med">
                                                    <div class="image">
                                                        <img class="br-sm" src="upimages/profile/3.png">
                                                    </div>
                                                </div>
                                                <div class="Layout-boxCard">
                                                    <div class="Layout-card">
                                                        <div class="layout-holder hero-holder">
                                                            <div class="Layout-heroHeader">
                                                                <div class="Layout-image Layout-profileImage -mt-xs">
                                                                    <img src="upimages/members/2.png">
                                                                </div>
                                                                <div class="profile-descContainer">
                                                                    <div class="profile-descContent">
                                                                        <div class="profile-desc t-txt">
                                                                            <h6 class="title">الوصف</h6>
                                                                            <p class="text txt-xs color-dark-grey">دكتورة سارة إبراهيم، خبيرة في طب الأنف والأذن والحنجرة، تمتلك تاريخاً لامعاً في مجالها المتميز. تتسم بحسها الطبي العميق  والفذ في تش دكتورة سارة إبراهيم، خبيرة في طب الأنف والأذن والحنجرة، تمتلك تاريخاً لامعاً في ...</p>
                                                                        </div>
                                                                        <div class="vcard-info">
                                                                            <div class="vcard-infoContent">
                                                                                <div class="vcard-social">
                                                                                    <div class="social icon-med">                                               <a href="" class="social-link">
                                                                                            <div class="fi-icon">
                                                                                                <svg viewBox="0 0 155.139 155.139">
                                                                                                    <use xlink:href="#i__facebook"></use>
                                                                                                </svg>
                                                                                            </div>
                                                                                        </a>
                                                                                        <a href="" target="_blank" class="social-link">
                                                                                            <div class="fi-icon">
                                                                                                <svg viewBox="0 0 18 18">
                                                                                                    <use xlink:href="#i__linkedin"></use>
                                                                                                </svg>
                                                                                            </div>
                                                                                        </a>
                                                                                        <a href="" target="_blank" class="social-link">
                                                                                            <div class="fi-icon">
                                                                                                <svg viewBox="0 0 409.592 409.592">
                                                                                                    <use xlink:href="#i__youtube"></use>
                                                                                                </svg>
                                                                                            </div>
                                                                                        </a>
                                                                                        <a href="" target="_blank" class="social-link">
                                                                                            <div class="fi-icon">
                                                                                                <svg viewBox="0 0 1226.37 1226.37">
                                                                                                    <use xlink:href="#i__twitter"></use>
                                                                                                </svg>
                                                                                            </div>
                                                                                        </a>
                                                                                        <a href="" target="_blank" class="social-link">
                                                                                            <div class="fi-icon">
                                                                                                <svg viewBox="0 0 32 32">
                                                                                                    <use xlink:href="#i__global"></use>
                                                                                                </svg>
                                                                                            </div>
                                                                                        </a>
                                                                                    </div>
                                                                                </div>
                                                                                <a data-fancybox data-src="#data-edit" class="btn bg-blue color-white hidden tablet-v-visible fancy-dialog">
                                                                                    <span class="btn-icon">
                                                                                        <svg viewBox="0 0 21 20">
                                                                                            <use xlink:href="#i_edit"></use>
                                                                                        </svg>
                                                                                    </span>
                                                                                </a>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="profile-dataEdit tablet-v-hidden">
                                                                        <a data-fancybox data-src="#data-edit" class="btn bg-blue color-white fancy-dialog">
                                                                            <span class="btn-icon">
                                                                                <svg viewBox="0 0 21 20">
                                                                                    <use xlink:href="#i_edit"></use>
                                                                                </svg>
                                                                            </span>
                                                                            <span class="btn-label">تعديل البيانات العامة</span>
                                                                        </a>
                                <div style="display: none;" id="data-edit" class="content__lightbox lb-med">
                                    <div class="popup__wrp">
                                        <div class="popup__holder ds-holder">
                                            <form class="form mod--form" action="" method="">
                                                <div class="fds-formCont">
                                                    <div class="fds-title -tl">
                                                        <h6>تعديل البيانات العامة</h6>
                                                        <div class="t-line abs-br bg-grey"></div>
                                                    </div>
                                                    <div class="fds-container">
                                                        <div class="fds-row">
                                                            <div class="pp-hero-header featured-block">
                                                                <div class="pp-hero-image Layout-coverImage si-filepond ui-med br-sm overflow relative color-black">
                                                                    <input type="file" class="my-pond" name="filepond" data-allow-reorder="true" data-max-files="1" data-image-paths="upimages/profile/3.png" />
                                                                </div>
<div class="Layout-boxCard over">
    <div class="Layout-card">
        <div class="layout-holder hero-holder">
            <div class="Layout-heroHeader update-hero">
                <div class="Layout-image Layout-profileImage ui-sm upload-img -uh relative ch-image">
                        <input type="file" class="circle-pond" name="filepond" data-allow-reorder="true" data-max-files="1" data-image-paths="upimages/members/2.png" />
                </div>
                <div class="profile-descContainer">
                    <div class="profile-descContent">
                        <div class="profile-desc t-txt">
                            <div class="auto-textBox color-dark-grey" contenteditable="true">دكتورة سارة إبراهيم، خبيرة في طب الأنف والأذن والحنجرة، تمتلك تاريخاً لامعاً في مجالها المتميز. تتسم بحسها الطبي العميق  والفذ في تش دكتورة سارة إبراهيم، خبيرة في طب الأنف والأذن والحنجرة، تمتلك تاريخاً لامعاً في ...</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
                                                            </div>
                                                        </div>
                                                        <div class="fds-row">
                                                            <div class="dm-data featured-block ft-pad">
                                                                <div class="dm-wrp t-txt">
                                                                    <div class="dm-content featured-block ft-pad">
                                                                        <div class="dm-dataColumns">
                                                                            <div class="dm-dataItem">
                                                                                <div class="label">الأسم</div>
                                                                                <div class="title">د/ سارة ابراهيم</div>
                                                                            </div>
                                                                            <div class="dm-dataItem">
                                                                                <div class="label">التخصص</div>
                                                                                <div class="title">أنف وأذن وحنجرة</div>
                                                                            </div>
                                                                            <div class="dm-dataItem">
                                                                                <div class="label">المسمى الوظيفي</div>
                                                                                <div class="title">أخصائي أنف وأذن وحنجرة</div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="dm-contact mt--xs">
                                                                        <div class="txt-xs color-dark-grey">
                                                                            إذا أردت تعديل البيانات الموثقة يرجى التواصل مع إدارة المنصة
                                                                            <a class="l-btn -lh color-blue" href="">
                                                                                <div class="l-label">تواصل معنا</div>
                                                                                <div class="l-icon -sc">
                                                                                    <svg viewBox="0 0 18 19">
                                                                                        <use xlink:href="#i_arrowLeft"></use>
                                                                                    </svg>
                                                                                </div>
                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="fds-row">
                                                            <div class="fds-desc bg-light-blue3 br-xs">
                                                                <div class="fds-descContent t-txt">
                                                                    <h6 class="title color-blue">الوصف</h6>
                                                                    <div class="txtarea-wrp text">
                                                                        
                            <div class="auto-textBox color-dark-grey" contenteditable="true">دكتورة سارة إبراهيم، خبيرة في طب الأنف والأذن والحنجرة، تمتلك تاريخاً لامعاً في مجالها المتميز. تتسم بحسها الطبي العميق  والفذ في تش دكتورة سارة إبراهيم، خبيرة في طب الأنف والأذن والحنجرة، تمتلك تاريخاً لامعاً في دكتورة سارة إبراهيم، خبيرة في طب الأنف والأذن والحنجرة، تمتلك تاريخاً لامعاً في مجالها المتميز. تتسم بحسها الطبي العميق  والفذ في تش دكتورة سارة إبراهيم، خبيرة في طب الأنف والأذن والحنجرة، تمتلك تاريخاً لامعاً في  دكتورة سارة إبراهيم، خبيرة في طب الأنف والأذن والحنجرة، تمتلك تاريخاً لامعاً في مجالها المتميز. تتسم بحسها الطبي العميق  والفذ في تش دكتورة سارة إبراهيم، خبيرة في طب الأنف والأذن والحنجرة، تمتلك تاريخاً لامعاً في  ...</div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="fds-row">
                                                            <div class="fds-social">
                                                                <h6 class="title">حسابات التواصل الاجتماعي</h6>
                                                                <div class="fds-fieldList icon-med mt--xs2">
                                                                    <div class="fds-fieldItem fw-icon">
                                                                        <div class="fi-icon">
                                                                            <svg viewBox="0 0 32 32">
                                                                                <use xlink:href="#i__global"></use>
                                                                            </svg>
                                                                        </div>
                                                                        <input type="text" class="input w-input field bg-light-blue3" placeholder="الموقع الإلكتروني" />
                                                                    </div>
                                                                    <div class="fds-fieldItem fw-icon">
                                                                        <div class="fi-icon">
                                                                            <svg viewBox="0 0 1226.37 1226.37">
                                                                                <use xlink:href="#i__twitter"></use>
                                                                            </svg>
                                                                        </div>
                                                                        <input type="text" class="input w-input field bg-light-blue3" placeholder="اكس" />
                                                                    </div>
                                                                    <div class="fds-fieldItem fw-icon">
                                                                        <div class="fi-icon">
                                                                            <svg viewBox="0 0 409.592 409.592">
                                                                                <use xlink:href="#i__youtube"></use>
                                                                            </svg>
                                                                        </div>
                                                                        <input type="text" class="input w-input field bg-light-blue3" placeholder="يوتيوب" />
                                                                    </div>
                                                                    <div class="fds-fieldItem fw-icon">
                                                                        <div class="fi-icon">
                                                                            <svg viewBox="0 0 18 18">
                                                                                <use xlink:href="#i__linkedin"></use>
                                                                            </svg>
                                                                        </div>
                                                                        <input type="text" class="input w-input field bg-light-blue3" placeholder="لينكد إن" />
                                                                    </div>
                                                                    <div class="fds-fieldItem fw-icon">
                                                                        <div class="fi-icon">
                                                                            <svg viewBox="0 0 155.139 155.139">
                                                                                <use xlink:href="#i__facebook"></use>
                                                                            </svg>
                                                                        </div>
                                                                        <input type="text" class="input w-input field bg-light-blue3" placeholder="فيسبوك" />
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="btns-group je mt--sm">
                                                            <button class="btn bg-blue color-white">حفظ</button>
                                                            <button class="btn bg-light-blue2 color-blue">إلغاء</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                        
                                    </div>

                                </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="dm-data featured-block ft-pad">
                                                <div class="dm-wrp t-txt">
                                                    <div class="dm-header t-txt">
                                                        <h6 class="title">البيانات الموثقة</h6>
                                                        <p class="text txt-xs color-dark-grey">إذا اردت تعديل البيانات التالية يرجى التوصل مع إدارة المنصة</p>
                                                    </div>
                                                    <div class="dm-content featured-block ft-pad mt--xs">
                                                        <div class="dm-dataColumns">
                                                            <div class="dm-dataItem">
                                                                <div class="label">الأسم</div>
                                                                <div class="title">د/ سارة ابراهيم</div>
                                                            </div>
                                                            <div class="dm-dataItem">
                                                                <div class="label">التخصص</div>
                                                                <div class="title">أنف وأذن وحنجرة</div>
                                                            </div>
                                                            <div class="dm-dataItem">
                                                                <div class="label">المسمى الوظيفي</div>
                                                                <div class="title">أخصائي أنف وأذن وحنجرة</div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="dm-contact mt--xs">
                                                        <div class="txt-xs color-dark-grey">
                                                            إذا أردت تعديل البيانات الموثقة يرجى التواصل مع إدارة المنصة
                                                            <a class="l-btn -lh color-blue" href="">
                                                                <div class="l-label">تواصل معنا</div>
                                                                <div class="l-icon -sc">
                                                                    <svg viewBox="0 0 18 19">
                                                                        <use xlink:href="#i_arrowLeft"></use>
                                                                    </svg>
                                                                </div>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
    <div class="tab-item num_2">
        <div class="ds-holder">
            <div class="lc-container">
                <div class="lc-block">
                    <div class="week-days">
                        <div class="weekday" data-id="saturday">
                            <div class="day-title">السبت</div>                                                                            
                        </div>
                        <div class="weekday" data-id="sunday">
                            <div class="day-title">الأحد</div>                                                                            
                        </div>
                        <div class="weekday" data-id="monday">
                            <div class="day-title">الأثنين</div>                                                                            
                        </div>
                        <div class="weekday" data-id="tuesday">
                            <div class="day-title">الثلثاء</div>                                                                            
                        </div>
                        <div class="weekday" data-id="wensday">
                            <div class="day-title">الأربعاء</div>                                                                            
                        </div>
                        <div class="weekday" data-id="thursday">
                            <div class="day-title">الخميس</div>                                                                            
                        </div>
                        <div class="weekday" data-id="friday">
                            <div class="day-title">الجمعة</div>                                                                            
                        </div>
                    </div>
                    <div class="periods-content">
                        <div class="periods-wrp">
                            <div class="period-list">
                                <div class="period-item js-periods" data-id="saturday">
<div class="period-card">
    <div class="pr-header color-blue">
        <div class="ph-icon">
            <svg viewBox="0 0 17 18">
                <use xlink:href="#i_hos"></use>
            </svg>
        </div>
        <div class="ph-title">المستشفى الأوروبي</div>
    </div>
    <div class="pr-content">
        <div class="pc-rows">
            <div class="pc-item">
                <div class="pc-label">فترة أولى</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
        </div>
    </div>
    <div class="pr-btns abs-br">
        <a class="pr-btn pr-btnDelete color-red2 bg-light-red" href="">
            <div class="pr-btnIcon">
                <svg viewBox="0 0 19 19">
                    <use xlink:href="#i_trash"></use>
                </svg>
            </div>
        </a>
        <a data-fancybox data-src="#edit-location-1" class="pr-btn pr-btnEdit color-blue fancy-dialog">
            <div class="pr-btnIcon -sc">
                <svg viewBox="0 0 21 20">
                    <use xlink:href="#i_edit"></use>
                </svg>
            </div>
        </a>
        <div style="display: none;" id="edit-location-1" class="content__lightbox lb-med">
            <div class="popup__wrp">
                <div class="popup__holder ds-holder">
                    <form class="form mod--form" action="" method="">
                        <div class="fds-formCont">
                            <div class="fds-title -tl">
                                <h6>عيادة الشفاء (فرع الستين)</h6>
                                <p class="color-dark-grey">َتعديل أيام وساعات الدوام في عيادة الشفاء (فرع الستين)</p>
                                <div class="t-line abs-br bg-grey"></div>
                            </div>
                            <div class="fds-container">  
                                <div class="fds-rows">  
                                    <div class="fds-row">  
                                        <div class="fds-location">
                                            <div class="lm-title">
                                                <span class="lm-icon -sc">
                                                    <svg viewBox="0 0 18 18">
                                                        <use xlink:href="#i__marker"></use>
                                                    </svg>
                                                </span>
                                                <h6 class="title">الموقع</h6>
                                            </div>
                                            <div class="fds-shiftRow">
                                                <div class="location-map relative">
                                                    <div class="location-search abs-tr">
                                                        <div class="nav-search search-wrap">
                                                            <div class="form-group">
                                                                <input type="text" class="input w-input field bg-white" placeholder="" required="">
                                                            </div>
                                                            <button type="submit" class="btn form__submit-button abs-tr">
                                                                <div class="form__submit-wrap">
                                                                <div class="icon mod--search-submit w-embed">
                                                                        <svg viewBox="0 0 22 22">
                                                                            <use xlink:href="#i_search"></use>
                                                                        </svg>
                                                                </div>
                                                                </div>
                                                            </button>
                                                        </div>
                                                    </div>
                                                    <div class="location-iframe bg-grey br-sm overflow">
                                                        <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3847.7170292397514!2d44.195971373857496!3d15.337605658610833!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x1603dbfa501dd7d7%3A0x60b12f2d7d144063!2z2YXYsdmD2LIg2KfZhNmD2YXZitmFINin2YTYqtis2KfYsdmK!5e0!3m2!1sen!2s!4v1721414831414!5m2!1sen!2s" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                                                    </div>
                                                </div>
                                                <div class="field-group mt--xs3">
                                                    <div class="field-item">
                                                        <div class="txtarea-wrp text">
                                                            <!-- <textarea type="text" class="w-field color-dark-grey auto-resize-textarea">وصف العنوان</textarea> -->
                                                            <div class="auto-textBox bg-light-blue3 color-dark-grey" contenteditable="true">وصف العنوان</div>
                                                        </div>
                                                    </div>
                                                    <div class="field-item">
                                                        <div class="txtarea-wrp text">
                                                            <div class="auto-textBox bg-light-blue3 color-dark-grey" contenteditable="true">ملاحظة على العنوان</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>  
                                    </div>  
                                    <div class="fds-row">  
                                        <div class="fds-location">
                                            <div class="lm-title">
                                                <span class="lm-icon -sc">
                                                    <svg viewBox="0 0 25 25">
                                                        <use xlink:href="#i_calender"></use>
                                                    </svg>
                                                </span>
                                                <h6 class="title">مواعيد الدوام</h6>
                                            </div>
                                            <div class="fds-shiftRow">
                                                <div class="schedule">
                                                    <div class="days-container">
                                                        <div class="day open">
                                                            <div class="switch">
                                                                <input type="checkbox" id="saturday2" class="day-switch" checked>
                                                                <label for="saturday2" class="day-btn"></label>
                                                                <span class="day-name">السبت</span>
                                                                <span class="status">مفتوح</span>
                                                            </div>
                                                            <div class="periods">
                                                                <div class="period">
                                                                    <label class="period-label">فترة أولى</label>
                                                                    <div class="time-container time-wrapper bg-light-blue3">
                                                                        <div class="time-wrapper-item">
                                                                            <input type="time" class="start-time" value="23:40">
                                                                        </div>
                                                                        <span class="to-label">إلى</span>
                                                                        <div class="time-wrapper-item">
                                                                            <input type="time" class="end-time" value="01:25">
                                                                        </div>
                                                                    </div>
                                                                    <div class="button remove-period">-</div>
                                                                    <div class="btn apply-to-all">
                                                                        <span class="btn-label">تطبيق التوقيت على باقي الفترات</span>
                                                                        <span class="btn-icon">
                                                                            <svg viewBox="0 0 16 16">
                                                                                <use xlink:href="#i_copy"></use>
                                                                            </svg>
                                                                        </span>
                                                                    </div>
                                                                </div>
                                                                <div class="period">
                                                                    <label class="period-label">فترة ثانية</label>
                                                                    <div class="time-container time-wrapper bg-light-blue3">
                                                                        <div class="time-wrapper-item">
                                                                            <input type="time" class="start-time" value="22:15">
                                                                        </div>
                                                                        <span class="to-label">إلى</span>
                                                                        <div class="time-wrapper-item">
                                                                            <input type="time" class="end-time" value="05:30">
                                                                        </div>
                                                                    </div>
                                                                    <div class="button remove-period">-</div>
                                                                    <div class="btn apply-to-all">
                                                                        <span class="btn-label">تطبيق التوقيت على باقي الفترات</span>
                                                                        <span class="btn-icon">
                                                                            <svg viewBox="0 0 16 16">
                                                                                <use xlink:href="#i_copy"></use>
                                                                            </svg>
                                                                        </span>
                                                                    </div>
                                                                </div>
                                                                
                                                                <div class="period">
                                                                    <label class="period-label">فترة ثالثة</label>
                                                                    <div class="time-container time-wrapper bg-light-blue3">
                                                                        <div class="time-wrapper-item">
                                                                            <input type="time" class="start-time" value="11:20">
                                                                        </div>
                                                                        <span class="to-label">إلى</span>
                                                                        <div class="time-wrapper-item">
                                                                            <input type="time" class="end-time" value="22:10">
                                                                        </div>
                                                                    </div>
                                                                    <div class="button add-period">+</div>
                                                                    <div class="btn apply-to-all">
                                                                        <span class="btn-label">تطبيق التوقيت على باقي الفترات</span>
                                                                        <span class="btn-icon">
                                                                            <svg viewBox="0 0 16 16">
                                                                                <use xlink:href="#i_copy"></use>
                                                                            </svg>
                                                                        </span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>  
                                                        <div class="day">
                                                            <div class="switch">
                                                                <input type="checkbox" id="sunday2" class="day-switch">
                                                                <label for="sunday2" class="day-btn"></label>
                                                                <span class="day-name">الأحد</span>
                                                                <span class="status">مغلق</span>
                                                            </div>
                                                            <div class="periods"></div>
                                                        </div> 
                                                        <div class="day">
                                                            <div class="switch">
                                                                <input type="checkbox" id="monday2" class="day-switch">
                                                                <label for="monday2" class="day-btn"></label>
                                                                <span class="day-name">الأثنين</span>
                                                                <span class="status">مغلق</span>
                                                            </div>
                                                            <div class="periods"></div>
                                                        </div> 
                                                        <div class="day">
                                                            <div class="switch">
                                                                <input type="checkbox" id="tuesday2" class="day-switch">
                                                                <label for="tuesday2" class="day-btn"></label>
                                                                <span class="day-name">الثلثاء</span>
                                                                <span class="status">مغلق</span>
                                                            </div>
                                                            <div class="periods"></div>
                                                        </div> 
                                                        <div class="day">
                                                            <div class="switch">
                                                                <input type="checkbox" id="wensday2" class="day-switch">
                                                                <label for="wensday2" class="day-btn"></label>
                                                                <span class="day-name">الأربعاء</span>
                                                                <span class="status">مغلق</span>
                                                            </div>
                                                            <div class="periods"></div>
                                                        </div> 
                                                        <div class="day">
                                                            <div class="switch">
                                                                <input type="checkbox" id="thursday2" class="day-switch">
                                                                <label for="thursday2" class="day-btn"></label>
                                                                <span class="day-name">الخميس</span>
                                                                <span class="status">مغلق</span>
                                                            </div>
                                                            <div class="periods"></div>
                                                        </div> 
                                                        <div class="day">
                                                            <div class="switch">
                                                                <input type="checkbox" id="friday2" class="day-switch">
                                                                <label for="friday2" class="day-btn"></label>
                                                                <span class="day-name">الجمعة</span>
                                                                <span class="status">مغلق</span>
                                                            </div>
                                                            <div class="periods"></div>
                                                        </div>                                                                                   
                                                    </div>
                                                </div>
                                            </div>
                                        </div>  
                                    </div> 
                                    <div class="fds-row">  
                                        <div class="fds-location">
                                            <div class="lm-title">
                                                <span class="lm-icon -sc">
                                                    <svg viewBox="0 0 19 18">
                                                        <use xlink:href="#i_call"></use>
                                                    </svg>
                                                </span>
                                                <h6 class="title">أرقام التواصل</h6>
                                            </div>
                                            <div class="fds-shiftRow">
                                                <div class="field-group">
                                                <div class="field-item">
                                                        <input type="text" class="input w-input field bg-light-blue3" placeholder="رقم الهاتف" required="">
                                                </div>    
                                                <div class="field-item">
                                                        <input type="text" class="input w-input field bg-light-blue3" placeholder="رقم الهاتف البديل (اختياري)" required="">
                                                </div>                                                                                     
                                                </div>
                                            </div>
                                        </div>  
                                    </div>
                                    <div class="btns-group je mt--sm">
                                        <button class="btn bg-blue color-white">إضافة</button>
                                        <button class="btn bg-light-blue2 color-blue">إلغاء</button>
                                    </div>
                                </div>  
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="period-card">
    <div class="pr-header color-blue">
        <div class="ph-icon">
            <svg viewBox="0 0 17 18">
                <use xlink:href="#i_hos"></use>
            </svg>
        </div>
        <div class="ph-title">المستشفى الأوروبي</div>
    </div>
    <div class="pr-content">
        <div class="pc-rows">
            <div class="pc-item">
                <div class="pc-label">فترة ثانية</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
            <div class="pc-item">
                <div class="pc-label">فترة أولى</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
        </div>
    </div>
    <div class="pr-btns abs-br">
        <a class="pr-btn pr-btnDelete color-red2 bg-light-red" href="">
            <div class="pr-btnIcon">
                <svg viewBox="0 0 19 19">
                    <use xlink:href="#i_trash"></use>
                </svg>
            </div>
        </a>
        <a data-fancybox data-src="#edit-location-1" class="pr-btn pr-btnEdit color-blue fancy-dialog">
            <div class="pr-btnIcon -sc">
                <svg viewBox="0 0 21 20">
                    <use xlink:href="#i_edit"></use>
                </svg>
            </div>
        </a>
    </div>
</div>
<div class="period-card">
    <div class="pr-header color-blue">
        <div class="ph-icon">
            <svg viewBox="0 0 17 18">
                <use xlink:href="#i_hos"></use>
            </svg>
        </div>
        <div class="ph-title">المستشفى الأوروبي</div>
    </div>
    <div class="pr-content">
        <div class="pc-rows">
            <div class="pc-item">
                <div class="pc-label">فترة ثانية</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
            <div class="pc-item">
                <div class="pc-label">فترة أولى</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
        </div>
    </div>
    <div class="pr-btns abs-br">
        <a class="pr-btn pr-btnDelete color-red2 bg-light-red" href="">
            <div class="pr-btnIcon">
                <svg viewBox="0 0 19 19">
                    <use xlink:href="#i_trash"></use>
                </svg>
            </div>
        </a>
        <a data-fancybox data-src="#edit-location-1" class="pr-btn pr-btnEdit color-blue fancy-dialog">
            <div class="pr-btnIcon -sc">
                <svg viewBox="0 0 21 20">
                    <use xlink:href="#i_edit"></use>
                </svg>
            </div>
        </a>
    </div>
</div>
                                </div>     
                                <div class="period-item js-periods" data-id="sunday">
                                    
<div class="period-card">
    <div class="pr-header color-blue">
        <div class="ph-icon">
            <svg viewBox="0 0 17 18">
                <use xlink:href="#i_hos"></use>
            </svg>
        </div>
        <div class="ph-title">المستشفى الأوروبي</div>
    </div>
    <div class="pr-content">
        <div class="pc-rows">
            <div class="pc-item">
                <div class="pc-label">فترة أولى</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
        </div>
    </div>
    <div class="pr-btns abs-br">
        <a class="pr-btn pr-btnDelete color-red2 bg-light-red" href="">
            <div class="pr-btnIcon">
                <svg viewBox="0 0 19 19">
                    <use xlink:href="#i_trash"></use>
                </svg>
            </div>
        </a>
        <a data-fancybox data-src="#edit-location-1" class="pr-btn pr-btnEdit color-blue fancy-dialog">
            <div class="pr-btnIcon -sc">
                <svg viewBox="0 0 21 20">
                    <use xlink:href="#i_edit"></use>
                </svg>
            </div>
        </a>
    </div>
</div>
<div class="period-card">
    <div class="pr-header color-blue">
        <div class="ph-icon">
            <svg viewBox="0 0 17 18">
                <use xlink:href="#i_hos"></use>
            </svg>
        </div>
        <div class="ph-title">المستشفى الأوروبي</div>
    </div>
    <div class="pr-content">
        <div class="pc-rows">
            <div class="pc-item">
                <div class="pc-label">فترة أولى</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
        </div>
    </div>
    <div class="pr-btns abs-br">
        <a class="pr-btn pr-btnDelete color-red2 bg-light-red" href="">
            <div class="pr-btnIcon">
                <svg viewBox="0 0 19 19">
                    <use xlink:href="#i_trash"></use>
                </svg>
            </div>
        </a>
        <a data-fancybox data-src="#edit-location-1" class="pr-btn pr-btnEdit color-blue fancy-dialog">
            <div class="pr-btnIcon -sc">
                <svg viewBox="0 0 21 20">
                    <use xlink:href="#i_edit"></use>
                </svg>
            </div>
        </a>
    </div>
</div>
<div class="period-card">
    <div class="pr-header color-blue">
        <div class="ph-icon">
            <svg viewBox="0 0 17 18">
                <use xlink:href="#i_hos"></use>
            </svg>
        </div>
        <div class="ph-title">المستشفى الأوروبي</div>
    </div>
    <div class="pr-content">
        <div class="pc-rows">
            <div class="pc-item">
                <div class="pc-label">فترة أولى</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
        </div>
    </div>
    <div class="pr-btns abs-br">
        <a class="pr-btn pr-btnDelete color-red2 bg-light-red" href="">
            <div class="pr-btnIcon">
                <svg viewBox="0 0 19 19">
                    <use xlink:href="#i_trash"></use>
                </svg>
            </div>
        </a>
        <a data-fancybox data-src="#edit-location-1" class="pr-btn pr-btnEdit color-blue fancy-dialog">
            <div class="pr-btnIcon -sc">
                <svg viewBox="0 0 21 20">
                    <use xlink:href="#i_edit"></use>
                </svg>
            </div>
        </a>
    </div>
</div>
<div class="period-card">
    <div class="pr-header color-blue">
        <div class="ph-icon">
            <svg viewBox="0 0 17 18">
                <use xlink:href="#i_hos"></use>
            </svg>
        </div>
        <div class="ph-title">المستشفى الأوروبي</div>
    </div>
    <div class="pr-content">
        <div class="pc-rows">
            <div class="pc-item">
                <div class="pc-label">فترة أولى</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
        </div>
    </div>
    <div class="pr-btns abs-br">
        <a class="pr-btn pr-btnDelete color-red2 bg-light-red" href="">
            <div class="pr-btnIcon">
                <svg viewBox="0 0 19 19">
                    <use xlink:href="#i_trash"></use>
                </svg>
            </div>
        </a>
        <a data-fancybox data-src="#edit-location-1" class="pr-btn pr-btnEdit color-blue fancy-dialog">
            <div class="pr-btnIcon -sc">
                <svg viewBox="0 0 21 20">
                    <use xlink:href="#i_edit"></use>
                </svg>
            </div>
        </a>
    </div>
</div>
                                </div> 
                                <div class="period-item js-periods" data-id="monday">
<div class="period-card">
    <div class="pr-header color-blue">
        <div class="ph-icon">
            <svg viewBox="0 0 17 18">
                <use xlink:href="#i_hos"></use>
            </svg>
        </div>
        <div class="ph-title">المستشفى الأوروبي</div>
    </div>
    <div class="pr-content">
        <div class="pc-rows">
            <div class="pc-item">
                <div class="pc-label">فترة ثالثة</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
            <div class="pc-item">
                <div class="pc-label">فترة ثانية</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
            <div class="pc-item">
                <div class="pc-label">فترة أولى</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
        </div>
    </div>
    <div class="pr-btns abs-br">
        <a class="pr-btn pr-btnDelete color-red2 bg-light-red" href="">
            <div class="pr-btnIcon">
                <svg viewBox="0 0 19 19">
                    <use xlink:href="#i_trash"></use>
                </svg>
            </div>
        </a>
        <a data-fancybox data-src="#edit-location-1" class="pr-btn pr-btnEdit color-blue fancy-dialog">
            <div class="pr-btnIcon -sc">
                <svg viewBox="0 0 21 20">
                    <use xlink:href="#i_edit"></use>
                </svg>
            </div>
        </a>
    </div>
</div>
<div class="period-card">
    <div class="pr-header color-blue">
        <div class="ph-icon">
            <svg viewBox="0 0 17 18">
                <use xlink:href="#i_hos"></use>
            </svg>
        </div>
        <div class="ph-title">المستشفى الأوروبي</div>
    </div>
    <div class="pr-content">
        <div class="pc-rows">
            <div class="pc-item">
                <div class="pc-label">فترة أولى</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
        </div>
    </div>
    <div class="pr-btns abs-br">
        <a class="pr-btn pr-btnDelete color-red2 bg-light-red" href="">
            <div class="pr-btnIcon">
                <svg viewBox="0 0 19 19">
                    <use xlink:href="#i_trash"></use>
                </svg>
            </div>
        </a>
        <a data-fancybox data-src="#edit-location-1" class="pr-btn pr-btnEdit color-blue fancy-dialog">
            <div class="pr-btnIcon -sc">
                <svg viewBox="0 0 21 20">
                    <use xlink:href="#i_edit"></use>
                </svg>
            </div>
        </a>
    </div>
</div>

                                </div>  
                                <div class="period-item js-periods" data-id="tuesday">
<div class="period-card">
    <div class="pr-header color-blue">
        <div class="ph-icon">
            <svg viewBox="0 0 17 18">
                <use xlink:href="#i_hos"></use>
            </svg>
        </div>
        <div class="ph-title">المستشفى الأوروبي</div>
    </div>
    <div class="pr-content">
        <div class="pc-rows">
            <div class="pc-item">
                <div class="pc-label">فترة أولى</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
        </div>
    </div>
    <div class="pr-btns abs-br">
        <a class="pr-btn pr-btnDelete color-red2 bg-light-red" href="">
            <div class="pr-btnIcon">
                <svg viewBox="0 0 19 19">
                    <use xlink:href="#i_trash"></use>
                </svg>
            </div>
        </a>
        <a data-fancybox data-src="#edit-location-1" class="pr-btn pr-btnEdit color-blue fancy-dialog">
            <div class="pr-btnIcon -sc">
                <svg viewBox="0 0 21 20">
                    <use xlink:href="#i_edit"></use>
                </svg>
            </div>
        </a>
    </div>
</div>
<div class="period-card">
    <div class="pr-header color-blue">
        <div class="ph-icon">
            <svg viewBox="0 0 17 18">
                <use xlink:href="#i_hos"></use>
            </svg>
        </div>
        <div class="ph-title">المستشفى الأوروبي</div>
    </div>
    <div class="pr-content">
        <div class="pc-rows">
            <div class="pc-item">
                <div class="pc-label">فترة ثانية</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
            <div class="pc-item">
                <div class="pc-label">فترة أولى</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
        </div>
    </div>
    <div class="pr-btns abs-br">
        <a class="pr-btn pr-btnDelete color-red2 bg-light-red" href="">
            <div class="pr-btnIcon">
                <svg viewBox="0 0 19 19">
                    <use xlink:href="#i_trash"></use>
                </svg>
            </div>
        </a>
        <a data-fancybox data-src="#edit-location-1" class="pr-btn pr-btnEdit color-blue fancy-dialog">
            <div class="pr-btnIcon -sc">
                <svg viewBox="0 0 21 20">
                    <use xlink:href="#i_edit"></use>
                </svg>
            </div>
        </a>
    </div>
</div>
<div class="period-card">
    <div class="pr-header color-blue">
        <div class="ph-icon">
            <svg viewBox="0 0 17 18">
                <use xlink:href="#i_hos"></use>
            </svg>
        </div>
        <div class="ph-title">المستشفى الأوروبي</div>
    </div>
    <div class="pr-content">
        <div class="pc-rows">
            <div class="pc-item">
                <div class="pc-label">فترة ثانية</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
            <div class="pc-item">
                <div class="pc-label">فترة أولى</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
        </div>
    </div>
    <div class="pr-btns abs-br">
        <a class="pr-btn pr-btnDelete color-red2 bg-light-red" href="">
            <div class="pr-btnIcon">
                <svg viewBox="0 0 19 19">
                    <use xlink:href="#i_trash"></use>
                </svg>
            </div>
        </a>
        <a data-fancybox data-src="#edit-location-1" class="pr-btn pr-btnEdit color-blue fancy-dialog">
            <div class="pr-btnIcon -sc">
                <svg viewBox="0 0 21 20">
                    <use xlink:href="#i_edit"></use>
                </svg>
            </div>
        </a>
    </div>
</div>
                                </div>
                                <div class="period-item js-periods" data-id="wensday">
<div class="period-card">
    <div class="pr-header color-blue">
        <div class="ph-icon">
            <svg viewBox="0 0 17 18">
                <use xlink:href="#i_hos"></use>
            </svg>
        </div>
        <div class="ph-title">المستشفى الأوروبي</div>
    </div>
    <div class="pr-content">
        <div class="pc-rows">
            <div class="pc-item">
                <div class="pc-label">فترة ثالثة</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
            <div class="pc-item">
                <div class="pc-label">فترة ثانية</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
            <div class="pc-item">
                <div class="pc-label">فترة أولى</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
        </div>
    </div>
    <div class="pr-btns abs-br">
        <a class="pr-btn pr-btnDelete color-red2 bg-light-red" href="">
            <div class="pr-btnIcon">
                <svg viewBox="0 0 19 19">
                    <use xlink:href="#i_trash"></use>
                </svg>
            </div>
        </a>
        <a data-fancybox data-src="#edit-location-1" class="pr-btn pr-btnEdit color-blue fancy-dialog">
            <div class="pr-btnIcon -sc">
                <svg viewBox="0 0 21 20">
                    <use xlink:href="#i_edit"></use>
                </svg>
            </div>
        </a>
    </div>
</div>
<div class="period-card">
    <div class="pr-header color-blue">
        <div class="ph-icon">
            <svg viewBox="0 0 17 18">
                <use xlink:href="#i_hos"></use>
            </svg>
        </div>
        <div class="ph-title">المستشفى الأوروبي</div>
    </div>
    <div class="pr-content">
        <div class="pc-rows">
            <div class="pc-item">
                <div class="pc-label">فترة أولى</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
        </div>
    </div>
    <div class="pr-btns abs-br">
        <a class="pr-btn pr-btnDelete color-red2 bg-light-red" href="">
            <div class="pr-btnIcon">
                <svg viewBox="0 0 19 19">
                    <use xlink:href="#i_trash"></use>
                </svg>
            </div>
        </a>
        <a data-fancybox data-src="#edit-location-1" class="pr-btn pr-btnEdit color-blue fancy-dialog">
            <div class="pr-btnIcon -sc">
                <svg viewBox="0 0 21 20">
                    <use xlink:href="#i_edit"></use>
                </svg>
            </div>
        </a>
    </div>
</div>
                                </div>                                   
                                <div class="period-item js-periods" data-id="thursday">
<div class="period-card">
    <div class="pr-header color-blue">
        <div class="ph-icon">
            <svg viewBox="0 0 17 18">
                <use xlink:href="#i_hos"></use>
            </svg>
        </div>
        <div class="ph-title">المستشفى الأوروبي</div>
    </div>
    <div class="pr-content">
        <div class="pc-rows">
            <div class="pc-item">
                <div class="pc-label">فترة أولى</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
        </div>
    </div>
    <div class="pr-btns abs-br">
        <a class="pr-btn pr-btnDelete color-red2 bg-light-red" href="">
            <div class="pr-btnIcon">
                <svg viewBox="0 0 19 19">
                    <use xlink:href="#i_trash"></use>
                </svg>
            </div>
        </a>
        <a data-fancybox data-src="#edit-location-1" class="pr-btn pr-btnEdit color-blue fancy-dialog">
            <div class="pr-btnIcon -sc">
                <svg viewBox="0 0 21 20">
                    <use xlink:href="#i_edit"></use>
                </svg>
            </div>
        </a>
    </div>
</div>
<div class="period-card">
    <div class="pr-header color-blue">
        <div class="ph-icon">
            <svg viewBox="0 0 17 18">
                <use xlink:href="#i_hos"></use>
            </svg>
        </div>
        <div class="ph-title">المستشفى الأوروبي</div>
    </div>
    <div class="pr-content">
        <div class="pc-rows">
            <div class="pc-item">
                <div class="pc-label">فترة ثانية</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
            <div class="pc-item">
                <div class="pc-label">فترة أولى</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
        </div>
    </div>
    <div class="pr-btns abs-br">
        <a class="pr-btn pr-btnDelete color-red2 bg-light-red" href="">
            <div class="pr-btnIcon">
                <svg viewBox="0 0 19 19">
                    <use xlink:href="#i_trash"></use>
                </svg>
            </div>
        </a>
        <a data-fancybox data-src="#edit-location-1" class="pr-btn pr-btnEdit color-blue fancy-dialog">
            <div class="pr-btnIcon -sc">
                <svg viewBox="0 0 21 20">
                    <use xlink:href="#i_edit"></use>
                </svg>
            </div>
        </a>
    </div>
</div>
<div class="period-card">
    <div class="pr-header color-blue">
        <div class="ph-icon">
            <svg viewBox="0 0 17 18">
                <use xlink:href="#i_hos"></use>
            </svg>
        </div>
        <div class="ph-title">المستشفى الأوروبي</div>
    </div>
    <div class="pr-content">
        <div class="pc-rows">
            <div class="pc-item">
                <div class="pc-label">فترة ثانية</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
            <div class="pc-item">
                <div class="pc-label">فترة أولى</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
        </div>
    </div>
    <div class="pr-btns abs-br">
        <a class="pr-btn pr-btnDelete color-red2 bg-light-red" href="">
            <div class="pr-btnIcon">
                <svg viewBox="0 0 19 19">
                    <use xlink:href="#i_trash"></use>
                </svg>
            </div>
        </a>
        <a data-fancybox data-src="#edit-location-1" class="pr-btn pr-btnEdit color-blue fancy-dialog">
            <div class="pr-btnIcon -sc">
                <svg viewBox="0 0 21 20">
                    <use xlink:href="#i_edit"></use>
                </svg>
            </div>
        </a>
    </div>
</div>
                                </div>
                                <div class="period-item js-periods" data-id="friday">
<div class="period-card">
    <div class="pr-header color-blue">
        <div class="ph-icon">
            <svg viewBox="0 0 17 18">
                <use xlink:href="#i_hos"></use>
            </svg>
        </div>
        <div class="ph-title">المستشفى الأوروبي</div>
    </div>
    <div class="pr-content">
        <div class="pc-rows">
            <div class="pc-item">
                <div class="pc-label">فترة أولى</div>
                <div class="pc-times">
                    <span class="pc-time">12:33 PM</span>
                    <span class="pc-mark">></span>
                    <span class="pc-time">12:33 PM</span>
                </div>
            </div>
        </div>
    </div>
    <div class="pr-btns abs-br">
        <a class="pr-btn pr-btnDelete color-red2 bg-light-red" href="">
            <div class="pr-btnIcon">
                <svg viewBox="0 0 19 19">
                    <use xlink:href="#i_trash"></use>
                </svg>
            </div>
        </a>
        <a data-fancybox data-src="#edit-location-1" class="pr-btn pr-btnEdit color-blue fancy-dialog">
            <div class="pr-btnIcon -sc">
                <svg viewBox="0 0 21 20">
                    <use xlink:href="#i_edit"></use>
                </svg>
            </div>
        </a>
    </div>
</div>
                                </div>
                            </div>                                                       
                        </div>
                    </div>
                </div>                                                             
            </div>
        </div>
    </div>
                                    <div class="tab-item num_3">
                                        <div class="ds-holder ds-maxCont">
                                            <div class="ds-archivBlock">
                                                <div class="Layout-conent__holder">
                                                    <div class="history-container">
                                                        <div class="history-menu">
                                                            <div class="history-card">
                                                                <div class="history-list">
                                                                    <div class="history-item">
                                                                        <div class="hs-wrap">
                                                                            <div class="layout-postItem">
                                                                                <div class="lp-content">
                                                                                    <div class="lp-title">
                                                                                        <h6> الحصول على شهادة الاعتماد الدولي "JCI"</h6>
                                                                                    </div>
                                                                                    <div class="lp-text color-dark-grey">
                                                                                    يسعدنا في [اسم المستشفى] أن نعلن عن حصولنا على شهادة الاعتماد الدولي "JCI" (Joint Commission International) وذلك بعد خضوعنا لتقييم دقيق وشامل من قبل خبراء اللجنة الدولية المشتركة. تُعد هذه الشهادة إنجازًا هامًا يضاف إلى سجل إنجازاتنا، ويعكس التزامنا بتقديم أفضل رعاية صحية لمرضانا وفق أعلى المعايير الدولية.
                                                                                    </div>
                                                                                    <div class="accordion-link">
                                                                                        <div class="accordion js-accordion">
                                                                                                <div class="accordion__item js-accordion-item js-showAll">
                                                                                                <div class="accordion-body js-accordion-body">
                                                                                                    <div class="accordion-body__contents color-dark-grey">
                                                                                                        <p>يسعدنا في [اسم المستشفى] أن نعلن عن حصولنا على شهادة الاعتماد الدولي "JCI" (Joint Commission International) وذلك بعد خضوعنا لتقييم دقيق وشامل من قبل خبراء اللجنة الدولية المشتركة. تُعد هذه الشهادة إنجازًا هامًا يضاف إلى سجل إنجازاتنا، ويعكس التزامنا بتقديم أفضل رعاية صحية لمرضانا وفق أعلى المعايير الدولية.</p>
                                                                                                    </div>
                                                                                                </div>
                                                                                                <div class="accordion-btn js-accordion-header js-updateScroll">
                                                                                                    <div class="link color-blue cursor">
                                                                                                            <div class="btn-label">عرض الكل</div>
                                                                                                    </div>
                                                                                                </div>
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="lp-gallery">
                                                                                        <div class="images-cards lp-imglist at-image">
                                                                                            <div class="imglist-item">
                                                                                                <a data-fancybox="gallery-31" href="upimages/awwards/1.png" class="fancy-imgList">
                                                                                                <img src="upimages/awwards/1.png">
                                                                                                </a>
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="lp-info color-dark-grey">
                                                                                    <div class="featured__article--info color-dark-grey">
                                                                                        <span class="f-date">17.مارس.2024</span>
                                                                                        <span class="dash">-</span>
                                                                                        <span class="view">1000 مشاهدة</span>
                                                                                    </div>
                                                                                    <div class="lp-btns">
                                                                                        <button class="lp-btn">
                                                                                            <div class="lp-icon">
                                                                                                <svg viewBox="0 0 20 20">
                                                                                                <use xlink:href="#i_send"></use>
                                                                                                </svg>
                                                                                            </div>
                                                                                        </button>
                                                                                        <button class="lp-btn open-popup-btn" data-popup="archive1">
                                                                                            <div class="lp-icon">
                                                                                                <svg viewBox="0 0 24 24">
                                                                                                <use xlink:href="#i_pen"></use>
                                                                                                </svg>
                                                                                            </div>
                                                                                        </button>
                                
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>

                                        <div class="history-card">
                                            <div class="history-list">
                                                <div class="history-item">
                                                    <div class="hs-wrap">
                                                        <div class="layout-postItem">
                                                            <div class="lp-content">
                                                                <div class="lp-title">
                                                                    <h6> الحصول على شهادة الاعتماد الدولي "JCI"</h6>
                                                                </div>
                                                                <div class="lp-text color-dark-grey">
                                                                يسعدنا في [اسم المستشفى] أن نعلن عن حصولنا على شهادة الاعتماد الدولي "JCI" (Joint Commission International) وذلك بعد خضوعنا لتقييم دقيق وشامل من قبل خبراء اللجنة الدولية المشتركة. تُعد هذه الشهادة إنجازًا هامًا يضاف إلى سجل إنجازاتنا، ويعكس التزامنا بتقديم أفضل رعاية صحية لمرضانا وفق أعلى المعايير الدولية.
                                                                </div>
                                                                <div class="accordion-link">
                                                                    <div class="accordion js-accordion">
                                                                            <div class="accordion__item js-accordion-item js-showAll">
                                                                            <div class="accordion-body js-accordion-body">
                                                                                <div class="accordion-body__contents color-dark-grey">
                                                                                    <p>يسعدنا في [اسم المستشفى] أن نعلن عن حصولنا على شهادة الاعتماد الدولي "JCI" (Joint Commission International) وذلك بعد خضوعنا لتقييم دقيق وشامل من قبل خبراء اللجنة الدولية المشتركة. تُعد هذه الشهادة إنجازًا هامًا يضاف إلى سجل إنجازاتنا، ويعكس التزامنا بتقديم أفضل رعاية صحية لمرضانا وفق أعلى المعايير الدولية.</p>
                                                                                </div>
                                                                            </div>
                                                                            <div class="accordion-btn js-accordion-header js-updateScroll">
                                                                                <div class="link color-blue cursor">
                                                                                        <div class="btn-label">عرض الكل</div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="lp-gallery">
                                                                    <div class="images-cards lp-imglist at-image">
                                                                        <div class="imglist-item">
                                                                            <a data-fancybox="gallery-31" href="upimages/awwards/1.png" class="fancy-imgList">
                                                                            <img src="upimages/awwards/1.png">
                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="lp-info color-dark-grey">
                                                                <div class="featured__article--info color-dark-grey">
                                                                    <span class="f-date">17.مارس.2024</span>
                                                                    <span class="dash">-</span>
                                                                    <span class="view">1000 مشاهدة</span>
                                                                </div>
                                                                <div class="lp-btns">
                                                                    <button class="lp-btn">
                                                                        <div class="lp-icon">
                                                                            <svg viewBox="0 0 20 20">
                                                                            <use xlink:href="#i_send"></use>
                                                                            </svg>
                                                                        </div>
                                                                    </button>
                                                                    <button class="lp-btn open-popup-btn" data-popup="archive2">
                                                                        <div class="lp-icon">
                                                                            <svg viewBox="0 0 24 24">
                                                                            <use xlink:href="#i_pen"></use>
                                                                            </svg>
                                                                        </div>
                                                                    </button>
                        
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php
   include('templates/footer.php');
?>