<?php
   $page_title = "profile";
   include('templates/header.php');
?>
    <section class="section inner-page in-mt">
        <div class="grid-container">
            <div class="grid grid-med">
                <div class="gutter">
                    <nav class="breadcrumbs color-dark-grey">
                        <ul class="trail-items">
                            <li class="trail-item">
                                <a href="index.php" class="trail-itemBlock trail-link trail-home">
                                    <svg class="hom-svg" viewBox="0 0 18 18">
                                        <use xlink:href="#i_home"></use>
                                    </svg> 
                                </a>
                            </li>
                            <li class="trail-item">
                                <span class="trail-arrow">
                                    <svg viewBox="0 0 18 18">
                                        <use xlink:href="#arrow_left"></use>
                                    </svg>
                                </span>
                                <div class="trail-itemBlock">
                                    <span class="trail-label">حسابي</span>
                                </div>
                            </li>
                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </section>

    <!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Photo Elements</title>
<link rel="stylesheet" href="styles.css">
</head>
<body>

<!-- First Element: Cover Photo -->
<div class="photo-container">
  <div class="overlay"></div>
  <img src="placeholder.jpg" alt="Cover Photo" id="cover-photo">
  <label for="cover-input" class="change-icon">
    <input type="file" id="cover-input" accept="image/*" onchange="handleCoverPhotoChange(event)">
    <i class="fas fa-camera"></i> Change Cover Photo
  </label>
  <div id="cover-loader" class="loader">Loading...</div>
</div>

<!-- Second Element: Profile Photo -->
<div class="photo-container">
  <div class="overlay"></div>
  <img src="placeholder.jpg" alt="Profile Photo" id="profile-photo">
  <label for="profile-input" class="change-icon">
    <input type="file" id="profile-input" accept="image/*" onchange="handleProfilePhotoChange(event)">
    <i class="fas fa-camera"></i> Change Profile Photo
  </label>
  <div id="profile-loader" class="loader">Loading...</div>
</div>

<!-- Third Element: Card for Adding Images -->
<div class="card">
  <input type="file" id="image-input" accept="image/*" onchange="handleImageUpload(event)" multiple>
  <label for="image-input" class="card-label">
    <i class="fas fa-upload"></i> Add Image(s) (Drag & Drop Supported)
  </label>
</div>

<script src="script.js"></script>
</body>
</html>

    <?php
   include('templates/footer.php');
?>